/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Command;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.GUIStarter;
import top.nserly.SoftwareCollections_API.FileHandle.JarVersionCleaner;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.String.RandomString;

public class CommandHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandHandle.class);
    private static final String CURRENT_JAR_PATH;
    private static final String CURRENT_JAR_NAME;
    private static final String CURRENT_JAR_PARENT_PATH;
    private static final String MainFileSuffix;
    private static final StringBuilder CommandComplement;

    public static void moveFileToDirectory(String DownloadMainFilePath) throws IOException {
        DownloadMainFilePath = DownloadMainFilePath.replace("\\", "/");
        Path sourcePath = Path.of(DownloadMainFilePath, new String[0]);
        Path destinationPath = Path.of("./" + DownloadMainFilePath.substring(DownloadMainFilePath.lastIndexOf("/") + 1) + MainFileSuffix, new String[0]);
        Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        log.info("Main File moved successfully.");
    }

    public static void moveFileToLibDirectory(ArrayList<String> DownloadLibFilePath) throws IOException {
        for (String string : DownloadLibFilePath) {
            string = string.replace("\\", "/");
            Path sourcePath = Path.of(string, new String[0]);
            Path destinationPath = Path.of("./lib/" + string.substring(string.lastIndexOf("/") + 1), new String[0]);
            Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
        JarVersionCleaner.cleanOldVersions("./lib/", true).forEach(CommandHandle::addDeletedStatement);
        log.info("Lib File moved successfully.");
    }

    public static String detectOSType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return "windows";
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return "linux";
        }
        return "unknown";
    }

    public static void executeOSSpecificCommands(String osType, String DownloadFilePath, String OpenedPicturePath) {
        switch (osType) {
            case "windows": {
                try {
                    CommandHandle.createAndRunWindowsBatchFile(DownloadFilePath, OpenedPicturePath);
                }
                catch (IOException e) {
                    log.error(ExceptionHandler.getExceptionMessage(e));
                    log.error("Automatic update failed");
                }
                break;
            }
            case "linux": {
                try {
                    CommandHandle.createAndRunLinuxShellScript(DownloadFilePath, OpenedPicturePath);
                }
                catch (IOException e) {
                    log.error(ExceptionHandler.getExceptionMessage(e));
                    log.error("Automatic update failed");
                }
                break;
            }
            default: {
                log.error("Unsupported OS:\"{}\"", (Object)osType);
            }
        }
    }

    public static void executeOSSpecificCommands(String osType, String DownloadFilePath) {
        CommandHandle.executeOSSpecificCommands(osType, DownloadFilePath, null);
    }

    public static void createAndRunWindowsBatchFile(String DownloadFilePath) throws IOException {
        CommandHandle.createAndRunWindowsBatchFile(DownloadFilePath, null);
    }

    public static void createAndRunWindowsBatchFile(String downloadFilePath, String openedPicturePath) throws IOException {
        String fileName = new File(downloadFilePath).getName();
        String batchContent = "@echo off\ntimeout /t 3 /nobreak >nul 2>&1\nif exist \".\\" + CURRENT_JAR_NAME + "\" (\n  del /f /q \".\\" + CURRENT_JAR_NAME + "\"\n)\nren \"" + fileName + MainFileSuffix + "\" \"" + CURRENT_JAR_NAME + "\"\n" + String.valueOf(CommandComplement) + "\ncls\n\"" + System.getProperty("java.home") + "\\bin\\java.exe\" -Dsun.java2d.opengl=true -DNUpdate=true -cp \"" + CURRENT_JAR_NAME + ";lib\\*\" top.nserly.GUIStarter ";
        if (openedPicturePath != null && !openedPicturePath.isBlank()) {
            batchContent = batchContent + "\"" + openedPicturePath + "\"";
        }
        Charset ansiCharset = Charset.forName("GBK");
        Path batchPath = Path.of(CURRENT_JAR_PARENT_PATH + File.separator + "replace.bat", new String[0]);
        Files.writeString(batchPath, (CharSequence)batchContent, ansiCharset, new OpenOption[0]);
        log.info("The script file is created!");
        log.info("Start running the script file and end the current software...");
        String batchFullPath = batchPath.toString();
        Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", "\"\"", batchFullPath});
        log.info("Program Termination!");
        GUIStarter.exitAndRecord();
    }

    public static void createAndRunLinuxShellScript(String DownloadFilePath) throws IOException {
        CommandHandle.createAndRunLinuxShellScript(DownloadFilePath, null);
    }

    public static void createAndRunLinuxShellScript(String downloadFilePath, String openedPicturePath) throws IOException {
        String shellContent = CommandHandle.getShellContent(downloadFilePath, openedPicturePath);
        Path shellPath = Path.of("./replace.sh", new String[0]);
        Files.writeString(shellPath, (CharSequence)shellContent, new OpenOption[0]);
        Files.setPosixFilePermissions(shellPath, PosixFilePermissions.fromString("rwx------"));
        log.info("The script file is created");
        log.info("Start running the script file and end the current software...");
        Runtime.getRuntime().exec(new String[]{"sh", "-c", "nohup sh ./replace.sh >/dev/null 2>&1 &"});
        log.info("Program Termination!");
        GUIStarter.exitAndRecord();
    }

    private static String getShellContent(String downloadFilePath, String openedPicturePath) {
        String fileName = new File(downloadFilePath).getName();
        String shellContent = "sleep 1\nrm " + CURRENT_JAR_NAME + "\nmv " + fileName + MainFileSuffix + " " + CURRENT_JAR_NAME + "\njava -Dsun.java2d.opengl=true -DNUpdate=true -cp " + CURRENT_JAR_NAME + ":lib/* top.nserly.GUIStarter ";
        if (openedPicturePath != null && !openedPicturePath.isBlank()) {
            shellContent = shellContent + openedPicturePath;
        }
        return shellContent;
    }

    private static void addDeletedStatement(String file) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            CommandComplement.append("del /f /q \".\\").append(file).append("\"\n");
            CommandComplement.append("if exist \".\\").append(file).append("\" (\n").append("  del /f /q \".\\").append(file).append("\"\n").append(")\n");
        } else if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            CommandComplement.append("rm ").append(file).append("\n");
        } else {
            throw new RuntimeException("OS is not supported currently!");
        }
    }

    static {
        CommandComplement = new StringBuilder();
        ClassLoader classLoader = CommandHandle.class.getClassLoader();
        URL url = classLoader.getResource(CommandHandle.class.getName().replace('.', '/') + ".class");
        if (url == null) {
            throw new RuntimeException("Can't find the current JAR file");
        }
        String path = url.getPath();
        CURRENT_JAR_PATH = path.substring(path.indexOf("/") + 1, path.lastIndexOf("!"));
        CURRENT_JAR_NAME = CURRENT_JAR_PATH.substring(CURRENT_JAR_PATH.lastIndexOf("/") + 1);
        MainFileSuffix = RandomString.getRandomString(5);
        CURRENT_JAR_PARENT_PATH = CURRENT_JAR_PATH.substring(0, CURRENT_JAR_PATH.lastIndexOf("/"));
        log.info("Current JAR file path: {}", (Object)CURRENT_JAR_PATH);
        log.info("Current JAR file name: {}", (Object)CURRENT_JAR_NAME);
        log.info("Current JAR file parent path: {}", (Object)CURRENT_JAR_PARENT_PATH);
        log.info("Main file suffix: {}", (Object)MainFileSuffix);
    }
}

