/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Loading;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bundle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Bundle.class);
    private static ResourceBundle bundle;
    private static Locale currentLocale;

    public static void setLocale(Locale locale) {
        currentLocale = locale;
        bundle = ResourceBundle.getBundle("messages", locale, new UTF8Control());
    }

    public static String getMessage(String key) {
        try {
            return bundle.getString(key);
        }
        catch (Exception e) {
            log.error("Resource bundle read failed:{}", (Object)key);
            return key;
        }
    }

    @Generated
    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    static {
        Bundle.setLocale(Locale.getDefault());
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            try (InputStream stream = loader.getResourceAsStream(resourceName);){
                PropertyResourceBundle propertyResourceBundle;
                if (stream == null) {
                    ResourceBundle resourceBundle = null;
                    return resourceBundle;
                }
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    propertyResourceBundle = new PropertyResourceBundle(reader);
                }
                return propertyResourceBundle;
            }
        }
    }
}

