/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Loading;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.PicturePlayer.Loading.DefaultArgs;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public class Init<KEY, VALUE> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Init.class);
    private static final AtomicBoolean isInit = new AtomicBoolean();
    private final File f = new File("data/configuration.ch");
    private final Properties properties = new Properties();
    private boolean EnableAutoUpdate;
    private static final String[] createDirectory = new String[]{"data", "lib", "cache", "cache/PictureCache", "cache/thum", "download"};
    private static final String[] createFile = new String[]{"data/PictureCacheManagement.obj"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        AtomicBoolean atomicBoolean = isInit;
        synchronized (atomicBoolean) {
            if (isInit.get()) {
                return;
            }
            try {
                File dire;
                for (String directory : createDirectory) {
                    dire = new File(directory);
                    if (dire.exists() || dire.mkdir()) continue;
                    log.warn("{} cannot mkdir", (Object)dire.getPath());
                }
                for (String file : createFile) {
                    dire = new File(file);
                    if (dire.exists() || dire.createNewFile()) continue;
                    log.warn("{} cannot create", (Object)dire.getPath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Init.clearDirectory(new File("./download/"));
            Init.clearDirectory(new File("replace.sh"));
            Init.clearDirectory(new File("replace.bat"));
            Init.clearDirectory(new File("runnable.bat"));
            isInit.set(true);
        }
    }

    public static void clearDirectory(File directory) {
        if (!directory.exists()) {
            return;
        }
        if (directory.isFile()) {
            if (!directory.delete()) {
                log.warn("{} cannot delete", (Object)directory.getPath());
            }
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Init.clearDirectory(file);
                    if (file.delete()) continue;
                    log.warn("{} cannot delete", (Object)file.getPath());
                    continue;
                }
                if (file.delete()) continue;
                log.warn("{} cannot delete", (Object)file.getPath());
            }
        }
    }

    public void run() {
        if (!isInit.get()) {
            Init.init();
        }
        try {
            if (!this.f.exists()) {
                this.writer(this.setDefault());
            }
            this.properties.clear();
            this.properties.load(new BufferedReader(new FileReader(this.f)));
        }
        catch (IOException e) {
            log.error("Failed to read the configuration file");
        }
    }

    public boolean containsKey(KEY key) {
        return this.properties.containsKey(key);
    }

    public void setUpdate(boolean EnableAutoUpdate) {
        this.EnableAutoUpdate = EnableAutoUpdate;
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public void changeValue(KEY key, VALUE value) {
        this.properties.remove(key.toString(), value.toString());
        this.properties.put(key.toString(), value.toString());
        if (this.EnableAutoUpdate) {
            this.store();
        }
    }

    public void remove(KEY key, VALUE value) {
        this.properties.remove(key.toString(), value.toString());
        if (this.EnableAutoUpdate) {
            this.store();
        }
    }

    public void update() {
        this.store();
    }

    @SafeVarargs
    public final void remove(KEY ... key) {
        for (KEY i : key) {
            this.properties.remove(i.toString());
        }
        if (this.EnableAutoUpdate) {
            this.store();
        }
    }

    public void writer(Map<String, String> map) {
        if (!isInit.get()) {
            Init.init();
        }
        this.properties.putAll(map);
        this.store();
    }

    public void writer(KEY key, VALUE value) {
        if (!isInit.get()) {
            Init.init();
        }
        this.properties.put(key.toString(), value.toString());
        this.store();
    }

    @DefaultArgs
    public Map<String, String> setDefault() {
        Method[] method;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Method i : method = DefaultArgs.class.getDeclaredMethods()) {
            hashMap.put(i.getName(), i.getDefaultValue().toString());
        }
        return hashMap;
    }

    private void store() {
        if (!isInit.get()) {
            Init.init();
        }
        try {
            this.properties.store(new BufferedWriter(new FileWriter(this.f)), "");
        }
        catch (Exception e) {
            log.error("Failed to save the configuration file");
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
    }
}

