/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.NComponent.Component;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.GUIStarter;
import top.nserly.PicturePlayer.NComponent.Component.PercentLabel;
import top.nserly.PicturePlayer.NComponent.Frame.FullScreenFrame;
import top.nserly.PicturePlayer.NComponent.Frame.PictureInformationViewer;
import top.nserly.PicturePlayer.Settings.SettingsInfoHandle;
import top.nserly.PicturePlayer.Size.OperatingCoordinate;
import top.nserly.PicturePlayer.Size.SizeOperate;
import top.nserly.PicturePlayer.Utils.ImageManager.Blur.Implements.BlurKernelSizeCompute;
import top.nserly.PicturePlayer.Utils.ImageManager.Blur.Implements.BlurProcessorHandleAction;
import top.nserly.PicturePlayer.Utils.ImageManager.Blur.Implements.OpenCLBlurProcessor;
import top.nserly.PicturePlayer.Utils.ImageManager.ImageRotationHelper;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.GetImageInformation;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageHandle;
import top.nserly.PicturePlayer.Utils.ImageManager.PictureInformationStorageManagement;
import top.nserly.PicturePlayer.Version.DownloadChecker.AdvancedDownloadSpeed;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.Thread.ThreadControl;

public class PaintPicturePanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PaintPicturePanel.class);
    public static PaintPicturePanel paintPicture;
    public final Thread init;
    public JPanel AboveMainPanel;
    public JPanel BelowMainPanel;
    public JPanel SouthLeftPanel;
    public JPanel SouthRightPanel;
    public JLabel PictureResolution;
    public JButton counterclockwise;
    public JButton Reset;
    public JButton FullScreen;
    public JButton clockwise;
    public JLabel PictureSize;
    public JButton reduceButton;
    public JSlider PercentSlider;
    public JButton enlargeButton;
    private static final int LastSign = 37;
    private static final int NextSign = 39;
    OperatingCoordinate op;
    Point MinPoint;
    Point MaxPoint;
    Dimension ShowingSize;
    Point LocationOnScreen;
    public PictureInformationViewer pictureInformationViewer;
    public SizeOperate sizeOperate;
    public ImageCanvas imageCanvas;
    PercentLabel percentLabel;
    Point mouseLocation;
    ArrayList<String> CurrentPathOfPicture;
    public static boolean isEnableHardwareAcceleration;
    private MouseAdapter mouseAdapter;
    private File lastPicturePathParent;
    private static boolean isMousePressed;
    public PictureInformationStorageManagement pictureInformationStorageManagement;
    public FullScreenFrame fullScreenWindow;
    private JPanel MainPanel;
    private JButton MorePictureInfoButton;
    private static Method $$$cachedGetBundleMethod$$$;

    public PaintPicturePanel(String path) {
        this();
        this.openPicture(path);
    }

    public PaintPicturePanel() {
        this.$$$setupUI$$$();
        paintPicture = this;
        this.loadPictureInformationStorageManagement();
        this.init = new Thread(() -> {
            ExceptionHandler.setUncaughtExceptionHandler(log);
            this.setLayout(new BorderLayout());
            this.fullScreenWindow = new FullScreenFrame();
            this.pictureInformationViewer = new PictureInformationViewer(GUIStarter.main);
            this.imageCanvas = new ImageCanvas(this);
            this.sizeOperate = new SizeOperate(this.imageCanvas, null);
            this.MainPanel.add((Component)this.imageCanvas, "Center");
            this.add((Component)this.MainPanel, "Center");
            if (isEnableHardwareAcceleration && OpenCLBlurProcessor.getIsSupportedOpenCL()) {
                OpenCLBlurProcessor.init();
            }
            this.validate();
        });
        this.init.setPriority(10);
        this.init.start();
        new Thread(() -> {
            this.init_Listener();
            this.waitInitComplete();
            this.PercentSlider.setMaximum(this.sizeOperate.MaxPercent);
            this.PercentSlider.setMinimum(this.sizeOperate.MinPercent);
            this.percentLabel.set((int)this.sizeOperate.getPercent());
            this.PercentSlider.setValue((int)this.sizeOperate.getPercent());
        }).start();
    }

    public void waitInitComplete() {
        ThreadControl.waitThreadsComplete(this.init);
    }

    public synchronized void fitComponent() {
        this.waitInitComplete();
        SwingUtilities.invokeLater(() -> {
            this.sizeOperate.incomeWindowDimension(this.imageCanvas.getSize());
            this.sizeOperate.changeCanvas(this.imageCanvas, true);
        });
    }

    private void loadPictureInTheParent(String picturePath) {
        File pictureParent = new File(picturePath).getParentFile();
        if (pictureParent == null) {
            picturePath = System.getProperty("user.dir");
            pictureParent = new File(picturePath);
        }
        if (!pictureParent.equals(this.lastPicturePathParent)) {
            this.lastPicturePathParent = pictureParent;
            this.refreshPictureThumbnail();
        }
    }

    public synchronized void refreshPictureThumbnail() {
        if (this.lastPicturePathParent == null || !this.lastPicturePathParent.exists()) {
            return;
        }
        this.CurrentPathOfPicture = GetImageInformation.getCurrentPathOfPicture(this.lastPicturePathParent.getPath());
        GUIStarter.main.reviewPictureList(this.CurrentPathOfPicture);
    }

    public void openPicture(String path) {
        this.changePicturePath(path);
    }

    public void openPicture(BufferedImage bufferedImage, String path) {
        this.changePicturePath(bufferedImage, path);
    }

    private void init_Listener() {
        this.FullScreen.addActionListener(e -> GUIStarter.paintPicture.imageCanvas.setFullScreen(true));
        AtomicLong ClickedTime = new AtomicLong();
        AtomicInteger times = new AtomicInteger();
        AtomicReference<Byte> lastRotationDegrees = new AtomicReference<Byte>((byte)0);
        this.Reset.addActionListener(e -> {
            if (System.currentTimeMillis() - ClickedTime.get() < 1500L) {
                if (this.imageCanvas.RotationDegrees != 0 && lastRotationDegrees.getAndSet(this.imageCanvas.RotationDegrees) != this.imageCanvas.RotationDegrees) {
                    this.sizeOperate.setPercent(this.sizeOperate.getPictureOptimalSize());
                    this.sizeOperate.update(false);
                    times.set(1);
                } else {
                    if (times.get() == 1) {
                        this.sizeOperate.restoreTheDefaultPercent();
                        this.sizeOperate.update(false);
                    } else if (times.get() == 2 && this.imageCanvas.RotationDegrees != 0) {
                        this.imageCanvas.reSetDegrees();
                        this.sizeOperate.setPercent(this.sizeOperate.getPictureOptimalSize());
                        this.sizeOperate.update(false);
                    } else if (times.get() == 3) {
                        this.sizeOperate.restoreTheDefaultPercent();
                        this.sizeOperate.update(false);
                    }
                    times.getAndIncrement();
                }
            } else {
                this.sizeOperate.setPercent(this.sizeOperate.getPictureOptimalSize());
                this.sizeOperate.update(false);
                times.set(1);
            }
            ClickedTime.set(System.currentTimeMillis());
        });
        this.clockwise.addActionListener(e -> this.imageCanvas.turnLeft());
        this.counterclockwise.addActionListener(e -> this.imageCanvas.turnRight());
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ PaintPicturePanel this$0;
            {
                PaintPicturePanel paintPicturePanel = this$0;
                Objects.requireNonNull(paintPicturePanel);
                this.this$0 = paintPicturePanel;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (this.this$0.fullScreenWindow.isShowing() || this.this$0.imageCanvas.getPath() == null) {
                    return;
                }
                this.this$0.sizeOperate.incomeWindowDimension(this.this$0.imageCanvas.getSize());
                this.this$0.sizeOperate.update(false);
            }
        });
        this.MorePictureInfoButton.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PaintPicturePanel this$0;
            {
                PaintPicturePanel paintPicturePanel = this$0;
                Objects.requireNonNull(paintPicturePanel);
                this.this$0 = paintPicturePanel;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.this$0.imageCanvas.getPath() != null && !this.this$0.imageCanvas.getPath().equals(this.this$0.pictureInformationViewer.getPicturePath())) {
                    try (ImageHandle imageHandle = GetImageInformation.getImageHandle(new File(this.this$0.imageCanvas.getPath()));){
                        this.this$0.pictureInformationViewer.update(imageHandle);
                    }
                    catch (IOException ex) {
                        log.error(ExceptionHandler.getExceptionMessage(ex));
                    }
                }
                this.this$0.pictureInformationViewer.setVisible(true);
            }
        });
        this.PercentSlider.addMouseListener(new MouseAdapter(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                isMousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                isMousePressed = false;
            }
        });
        this.PercentSlider.addChangeListener(e -> {
            if (isMousePressed) {
                this.percentLabel.set(this.PercentSlider.getValue());
                this.sizeOperate.setPercent(this.PercentSlider.getValue());
                this.sizeOperate.update(false);
            }
        });
        this.reduceButton.addMouseListener(new MouseAdapter(this){
            private ScheduledExecutorService executor;
            final /* synthetic */ PaintPicturePanel this$0;
            {
                PaintPicturePanel paintPicturePanel = this$0;
                Objects.requireNonNull(paintPicturePanel);
                this.this$0 = paintPicturePanel;
                this.executor = null;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.executor != null && !this.executor.isShutdown()) {
                    this.executor.shutdownNow();
                    this.executor.close();
                }
                this.executor = Executors.newSingleThreadScheduledExecutor();
                this.executor.scheduleAtFixedRate(() -> {
                    if (!this.this$0.reduceButton.isEnabled()) {
                        return;
                    }
                    if (this.this$0.sizeOperate.adjustPercent(1)) {
                        this.this$0.sizeOperate.update(false);
                    }
                }, 0L, 16L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.executor != null && !this.executor.isShutdown()) {
                    this.executor.shutdownNow();
                    this.executor.close();
                }
            }
        });
        this.enlargeButton.addMouseListener(new MouseAdapter(this){
            private ScheduledExecutorService executor;
            final /* synthetic */ PaintPicturePanel this$0;
            {
                PaintPicturePanel paintPicturePanel = this$0;
                Objects.requireNonNull(paintPicturePanel);
                this.this$0 = paintPicturePanel;
                this.executor = null;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.executor != null && !this.executor.isShutdown()) {
                    this.executor.shutdownNow();
                    this.executor.close();
                }
                this.executor = Executors.newSingleThreadScheduledExecutor();
                this.executor.scheduleAtFixedRate(() -> {
                    if (!this.this$0.enlargeButton.isEnabled()) {
                        return;
                    }
                    if (this.this$0.sizeOperate.adjustPercent(0)) {
                        this.this$0.sizeOperate.update(false);
                    }
                }, 0L, 16L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.executor != null && !this.executor.isShutdown()) {
                    this.executor.shutdownNow();
                    this.executor.close();
                }
            }
        });
    }

    private void setPictureInformationOnComponent(BufferedImage bufferedImage, String path) {
        if (this.PictureSize == null) {
            return;
        }
        File PictureFile = new File(path);
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.PictureSize.setText(AdvancedDownloadSpeed.formatBytes(PictureFile.length()));
        this.PictureResolution.setText((int)dimension.getWidth() + "x" + (int)dimension.getHeight());
    }

    private void loadPictureInformationStorageManagement() {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream("data/PictureCacheManagement.obj"));){
            this.pictureInformationStorageManagement = (PictureInformationStorageManagement)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
            this.pictureInformationStorageManagement = new PictureInformationStorageManagement();
        }
    }

    private void savePictureInformationStorageManagement() {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream("data/PictureCacheManagement.obj"));){
            objectOutputStream.writeObject(this.pictureInformationStorageManagement);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
    }

    public void changePicturePath(String path) {
        AtomicReference hashCode = new AtomicReference();
        AtomicReference image = new AtomicReference();
        Thread getHashCodeThread = new Thread(() -> hashCode.set(GetImageInformation.getHashcode(new File(path))));
        Thread getBufferedImage = new Thread(() -> image.set(GetImageInformation.getImage(path)));
        getHashCodeThread.start();
        getBufferedImage.start();
        ThreadControl.waitThreadsComplete(getHashCodeThread, getBufferedImage, this.init);
        this.changePicturePath((BufferedImage)image.get(), path, (String)hashCode.get());
    }

    public void changePicturePath(BufferedImage bufferedImage, String path) {
        this.changePicturePath(bufferedImage, path, GetImageInformation.getHashcode(new File(path)));
    }

    public synchronized void changePicturePath(BufferedImage bufferedImage, String path, String picture_hashcode) {
        log.info("Opened:\"{}\"", (Object)path);
        this.waitInitComplete();
        this.validate();
        this.imageCanvas.changePicturePath(bufferedImage, path, picture_hashcode);
    }

    private void $$$setupUI$$$() {
        this.MainPanel = new JPanel();
        this.MainPanel.setLayout(new BorderLayout(0, 0));
        this.MainPanel.setRequestFocusEnabled(false);
        this.AboveMainPanel = new JPanel();
        this.AboveMainPanel.setLayout(new FlowLayout(1, 5, 5));
        this.AboveMainPanel.setRequestFocusEnabled(false);
        this.MainPanel.add((Component)this.AboveMainPanel, "North");
        this.counterclockwise = new JButton();
        this.counterclockwise.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.counterclockwise, this.$$$getMessageFromBundle$$$("messages", "Display_RotateCounterclockwise"));
        this.AboveMainPanel.add(this.counterclockwise);
        this.Reset = new JButton();
        this.Reset.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.Reset, this.$$$getMessageFromBundle$$$("messages", "Display_reset"));
        this.AboveMainPanel.add(this.Reset);
        this.FullScreen = new JButton();
        this.FullScreen.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.FullScreen, this.$$$getMessageFromBundle$$$("messages", "Display_FullScreenButton"));
        this.AboveMainPanel.add(this.FullScreen);
        this.clockwise = new JButton();
        this.clockwise.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.clockwise, this.$$$getMessageFromBundle$$$("messages", "Display_RotateClockwiseButton"));
        this.AboveMainPanel.add(this.clockwise);
        this.percentLabel = new PercentLabel();
        this.percentLabel.setText("0%");
        this.AboveMainPanel.add(this.percentLabel);
        this.BelowMainPanel = new JPanel();
        this.BelowMainPanel.setLayout(new BorderLayout(1, 2));
        this.BelowMainPanel.setRequestFocusEnabled(false);
        this.MainPanel.add((Component)this.BelowMainPanel, "South");
        this.SouthLeftPanel = new JPanel();
        this.SouthLeftPanel.setLayout(new FlowLayout(3, 5, 5));
        this.SouthLeftPanel.setRequestFocusEnabled(false);
        this.BelowMainPanel.add((Component)this.SouthLeftPanel, "West");
        this.PictureResolution = new JLabel();
        Font PictureResolutionFont = this.$$$getFont$$$(null, -1, 15, this.PictureResolution.getFont());
        if (PictureResolutionFont != null) {
            this.PictureResolution.setFont(PictureResolutionFont);
        }
        this.PictureResolution.setRequestFocusEnabled(false);
        this.PictureResolution.setText("");
        this.SouthLeftPanel.add(this.PictureResolution);
        this.PictureSize = new JLabel();
        Font PictureSizeFont = this.$$$getFont$$$(null, -1, 15, this.PictureSize.getFont());
        if (PictureSizeFont != null) {
            this.PictureSize.setFont(PictureSizeFont);
        }
        this.PictureSize.setRequestFocusEnabled(false);
        this.PictureSize.setText("");
        this.SouthLeftPanel.add(this.PictureSize);
        this.MorePictureInfoButton = new JButton();
        this.$$$loadButtonText$$$(this.MorePictureInfoButton, this.$$$getMessageFromBundle$$$("messages", "PictureViewer_MorePictureInfoButton"));
        this.SouthLeftPanel.add(this.MorePictureInfoButton);
        this.SouthRightPanel = new JPanel();
        this.SouthRightPanel.setLayout(new FlowLayout(2, 5, 5));
        this.SouthRightPanel.setRequestFocusEnabled(false);
        this.BelowMainPanel.add((Component)this.SouthRightPanel, "East");
        this.reduceButton = new JButton();
        this.reduceButton.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.reduceButton, this.$$$getMessageFromBundle$$$("messages", "Display_reduce"));
        this.SouthRightPanel.add(this.reduceButton);
        this.PercentSlider = new JSlider();
        this.PercentSlider.setRequestFocusEnabled(false);
        this.SouthRightPanel.add(this.PercentSlider);
        this.enlargeButton = new JButton();
        this.enlargeButton.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.enlargeButton, this.$$$getMessageFromBundle$$$("messages", "Display_enlarge"));
        this.SouthRightPanel.add(this.enlargeButton);
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    private String $$$getMessageFromBundle$$$(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if ($$$cachedGetBundleMethod$$$ == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                $$$cachedGetBundleMethod$$$ = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)$$$cachedGetBundleMethod$$$.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.MainPanel;
    }

    @Generated
    public ArrayList<String> getCurrentPathOfPicture() {
        return this.CurrentPathOfPicture;
    }

    static {
        $$$cachedGetBundleMethod$$$ = null;
    }

    public class ImageCanvas
    extends JComponent {
        String path;
        private boolean isEnableHardware;
        String lastPath;
        String picture_hashcode;
        private double X;
        private double Y;
        private double mouseX;
        private double mouseY;
        private double LastPercent;
        private double lastWidth;
        private double lastHeight;
        private BufferedImage image;
        OpenCLBlurProcessor openCLBlurProcessor;
        private Dimension NewWindow;
        private Dimension LastWindow;
        private byte RotationDegrees;
        private byte lastRotationDegrees;
        private boolean isMove;
        private boolean isNeedBlurToView;
        private Timer timer;
        private BufferedImage BlurBufferedImage;
        private boolean isLowOccupancyMode;
        private final BlurProcessorHandleAction blurProcessorHandleAction;
        final /* synthetic */ PaintPicturePanel this$0;

        public ImageCanvas(PaintPicturePanel this$0) {
            PaintPicturePanel paintPicturePanel = this$0;
            Objects.requireNonNull(paintPicturePanel);
            this.this$0 = paintPicturePanel;
            this.isLowOccupancyMode = false;
            this.setDoubleBuffered(true);
            new Thread(this::init_listener).start();
            this.blurProcessorHandleAction = () -> {
                if (this.image != null) {
                    BufferedImage bufferedImage = GetImageInformation.castToTYPEINTRGB(this.image);
                    bufferedImage.flush();
                    return bufferedImage;
                }
                return null;
            };
            new Thread(() -> {
                this.isEnableHardware = isEnableHardwareAcceleration;
                if (this.isEnableHardware) {
                    this.openCLBlurProcessor = new OpenCLBlurProcessor();
                    this.openCLBlurProcessor.setHandleAction(this.blurProcessorHandleAction);
                }
                this.timer = new Timer(400, e -> {
                    if (this.BlurBufferedImage != null) {
                        this.BlurBufferedImage.flush();
                        this.BlurBufferedImage.getGraphics().dispose();
                        this.BlurBufferedImage = null;
                    }
                    if (!this.isEnableHardware) {
                        return;
                    }
                    ((Timer)e.getSource()).stop();
                    new Thread(() -> {
                        if (this.image != null && this.openCLBlurProcessor != null) {
                            int KernelSize = BlurKernelSizeCompute.calculateKernelSize(this.image, this$0.sizeOperate.getPercent());
                            this.BlurBufferedImage = this.openCLBlurProcessor.applyBlur(KernelSize);
                            this.isNeedBlurToView = true;
                            this.repaint();
                        }
                    }).start();
                });
            }).start();
        }

        public ImageCanvas(PaintPicturePanel this$0, String path) {
            this(this$0);
            this.changePicturePath(path);
        }

        public ImageCanvas(PaintPicturePanel this$0, String path, String picture_hashcode) {
            this(this$0);
            this.changePicturePath(path, picture_hashcode);
        }

        public synchronized void setLowOccupancyMode(boolean isLowOccupancyMode) {
            if (this.isLowOccupancyMode == isLowOccupancyMode) {
                return;
            }
            this.isLowOccupancyMode = isLowOccupancyMode;
            if (isLowOccupancyMode) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                OpenCLBlurProcessor.closeBlurProcessor();
                if (this.openCLBlurProcessor != null) {
                    this.openCLBlurProcessor.close();
                }
                if (this.image != null) {
                    this.image.flush();
                }
                if (this.BlurBufferedImage != null) {
                    this.BlurBufferedImage.flush();
                }
                this.BlurBufferedImage = null;
                this.image = null;
                GUIStarter.main.reviewPictureList(null);
            } else {
                if (this.path == null) {
                    return;
                }
                this.image = GetImageInformation.getImage(this.this$0.pictureInformationStorageManagement.getCachedPicturePath(this.path, this.picture_hashcode));
                this.isEnableHardware = isEnableHardwareAcceleration;
                if (this.isEnableHardware) {
                    new Thread(() -> {
                        BufferedImage srcBlurBufferedImage = GetImageInformation.castToTYPEINTRGB(this.image);
                        if (this.openCLBlurProcessor == null) {
                            this.openCLBlurProcessor = new OpenCLBlurProcessor();
                            this.openCLBlurProcessor.setHandleAction(this.blurProcessorHandleAction);
                        }
                        this.openCLBlurProcessor.changeImage(srcBlurBufferedImage);
                        srcBlurBufferedImage.flush();
                        GUIStarter.main.reviewPictureList(this.this$0.CurrentPathOfPicture);
                    }).start();
                }
            }
        }

        public void turnLeft() {
            this.addDegrees((byte)1);
        }

        public void turnRight() {
            this.addDegrees((byte)-1);
        }

        public void reSetDegrees() {
            this.RotationDegrees = 0;
            if (this.lastRotationDegrees != this.RotationDegrees) {
                this.this$0.sizeOperate.changeCanvas(this, true);
            }
        }

        private void addDegrees(byte addDegrees) {
            this.RotationDegrees = (byte)(this.RotationDegrees + addDegrees);
            this.RotationDegrees = (byte)(this.RotationDegrees % 4);
            if (this.RotationDegrees < 0) {
                this.RotationDegrees = (byte)(4 + this.RotationDegrees);
            }
            this.this$0.sizeOperate.update(false);
        }

        private void setDegrees(int Degrees) {
            this.RotationDegrees = (byte)(Degrees % 4);
            if (this.RotationDegrees < 0) {
                this.RotationDegrees = (byte)(4 + this.RotationDegrees);
            }
            this.this$0.sizeOperate.changeCanvas(this, true);
        }

        public int getDegrees() {
            return Math.abs(this.RotationDegrees) * 90;
        }

        public void changePicturePath(String path) {
            this.changePicturePath(path, GetImageInformation.getHashcode(new File(path)));
        }

        public void changePicturePath(BufferedImage image, String path) {
            this.changePicturePath(image, path, GetImageInformation.getHashcode(new File(path)));
        }

        public void changePicturePath(String path, String picture_hashcode) {
            BufferedImage image = GetImageInformation.getImage(this.this$0.pictureInformationStorageManagement.getCachedPicturePath(path, picture_hashcode));
            this.changePicturePath(image, path, picture_hashcode);
        }

        public void changePicturePath(BufferedImage image, String path, String picture_hashcode) {
            if (image == null) {
                throw new RuntimeException("Image is null, cannot change picture path.");
            }
            if (path.startsWith("\"") && path.endsWith("\"")) {
                path = path.substring(1, path.length() - 1);
            }
            String finalPath = path;
            this.timer.stop();
            boolean isRepeat = path.equals(this.path) && picture_hashcode.equals(this.picture_hashcode);
            this.isEnableHardware = isEnableHardwareAcceleration;
            if (!isRepeat) {
                this.path = path;
                this.picture_hashcode = picture_hashcode;
                this.lastRotationDegrees = 0;
                this.RotationDegrees = 0;
                this.mouseX = this.mouseY = (double)0;
                this.Y = this.mouseY;
                this.X = this.mouseY;
                this.lastHeight = this.mouseY;
                this.lastWidth = this.mouseY;
                this.LastPercent = this.mouseY;
                this.LastWindow = null;
                this.NewWindow = null;
                if (this.image != null) {
                    this.image.flush();
                }
                if (this.BlurBufferedImage != null) {
                    this.BlurBufferedImage.flush();
                }
                this.BlurBufferedImage = null;
            }
            this.image = image;
            this.this$0.fitComponent();
            if (this.isLowOccupancyMode) {
                this.isLowOccupancyMode = false;
            }
            new Thread(() -> {
                if (!isRepeat) {
                    this.this$0.setPictureInformationOnComponent(image, finalPath);
                }
                this.this$0.loadPictureInTheParent(finalPath);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                System.gc();
            }).start();
            if (this.isEnableHardware && !isRepeat) {
                new Thread(() -> {
                    BufferedImage srcBlurBufferedImage = GetImageInformation.castToTYPEINTRGB(image);
                    if (this.openCLBlurProcessor == null) {
                        this.openCLBlurProcessor = new OpenCLBlurProcessor();
                        this.openCLBlurProcessor.setHandleAction(this.blurProcessorHandleAction);
                    }
                    this.openCLBlurProcessor.changeImage(srcBlurBufferedImage);
                    srcBlurBufferedImage.flush();
                }).start();
            }
        }

        public void close() {
            this.removeAll();
            this.this$0.savePictureInformationStorageManagement();
            this.timer.stop();
            if (this.openCLBlurProcessor != null) {
                this.openCLBlurProcessor.close();
            }
            OpenCLBlurProcessor.closeBlurProcessor();
            this.openCLBlurProcessor = null;
            this.BlurBufferedImage = null;
            this.image = null;
            this.picture_hashcode = null;
            this.lastPath = null;
            this.path = null;
            this.RotationDegrees = 0;
            this.lastRotationDegrees = 0;
            this.mouseX = this.mouseY = (double)0;
            this.Y = this.mouseY;
            this.X = this.mouseY;
            this.lastHeight = this.mouseY;
            this.lastWidth = this.mouseY;
            this.LastPercent = this.mouseY;
            this.LastWindow = null;
            this.NewWindow = null;
            this.isMove = false;
            this.isNeedBlurToView = false;
            this.timer = null;
            System.gc();
        }

        public void setWindowSize(Dimension window) {
            this.NewWindow = window;
        }

        public int getImageHeight() {
            if (this.image == null) {
                return 0;
            }
            return this.image.getHeight();
        }

        public int getImageWidth() {
            if (this.image == null) {
                return 0;
            }
            return this.image.getWidth();
        }

        public synchronized void openLONPicture(int sign) {
            int CurrentIndex = this.this$0.CurrentPathOfPicture.indexOf(this.this$0.imageCanvas.path);
            int openIndex = sign == 37 ? CurrentIndex - 1 : (sign == 39 ? CurrentIndex + 1 : -1);
            try {
                this.openPicture(openIndex);
            }
            catch (NullPointerException e) {
                log.error("Cannot open picture: {}", (Object)this.this$0.CurrentPathOfPicture.get(openIndex));
                log.error(ExceptionHandler.getExceptionMessage(e));
                this.this$0.CurrentPathOfPicture.remove(openIndex);
                this.openLONPicture(sign);
            }
        }

        private synchronized void openPicture(int index) throws NullPointerException {
            if (index >= 0 && index < this.this$0.CurrentPathOfPicture.size()) {
                log.info("Opened:\"{}\"", (Object)this.this$0.CurrentPathOfPicture.get(index));
                this.this$0.imageCanvas.changePicturePath(this.this$0.CurrentPathOfPicture.get(index));
                this.this$0.sizeOperate.update(false);
            }
        }

        public boolean hasNext(int sign) {
            int CurrentIndex = this.this$0.CurrentPathOfPicture.indexOf(this.this$0.imageCanvas.path);
            switch (sign) {
                case 37: {
                    if (CurrentIndex <= 0) break;
                    return true;
                }
                case 39: {
                    if (CurrentIndex + 1 >= this.this$0.CurrentPathOfPicture.size()) break;
                    return true;
                }
            }
            return false;
        }

        @Override
        public synchronized void paint(Graphics g) {
            if (this.isLowOccupancyMode) {
                this.setLowOccupancyMode(false);
            }
            if (this.isLowOccupancyMode || this.NewWindow == null || this.NewWindow.width == 0 || this.NewWindow.height == 0 || this.LastPercent == this.this$0.sizeOperate.getPercent() && (double)this.RotationDegrees == this.LastPercent && !this.isMove && this.lastPath.equals(this.path) || this.getImageWidth() == 0 || this.getImageHeight() == 0) {
                g.dispose();
                return;
            }
            this.timer.stop();
            double FinalX = this.X;
            double FinalY = this.Y;
            Graphics2D graphics2D = (Graphics2D)g;
            graphics2D.rotate(Math.toRadians(this.RotationDegrees * 90));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (this.isNeedBlurToView && this.BlurBufferedImage != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.drawImage(this.BlurBufferedImage, (int)this.X, (int)this.Y, (int)this.lastWidth, (int)this.lastHeight, null);
                this.isNeedBlurToView = false;
                g.dispose();
                this.BlurBufferedImage.getGraphics().dispose();
                this.BlurBufferedImage.flush();
                this.BlurBufferedImage = null;
                return;
            }
            double tempWidth = this.lastHeight;
            double tempHeight = this.lastWidth;
            if (this.RotationDegrees == 1) {
                temp = this.mouseX;
                this.mouseX = this.mouseY;
                this.mouseY = -temp;
            } else if (this.RotationDegrees == 2) {
                this.mouseX = -this.mouseX;
                this.mouseY = -this.mouseY;
            } else if (this.RotationDegrees == 3) {
                temp = this.mouseX;
                this.mouseX = -this.mouseY;
                this.mouseY = temp;
            }
            double WindowWidth = this.NewWindow.getWidth();
            double WindowHeight = this.NewWindow.getHeight();
            if (this.LastWindow == null || this.LastWindow.width == 0 || this.LastWindow.height == 0) {
                this.LastWindow = this.NewWindow;
            }
            double LastWindowWidth = this.LastWindow.getWidth();
            double LastWindowHeight = this.LastWindow.getHeight();
            if (this.isMove && this.RotationDegrees == this.lastRotationDegrees && this.LastPercent == this.this$0.sizeOperate.getPercent() && this.LastWindow != null && this.LastWindow.equals(this.NewWindow)) {
                this.X += this.mouseX;
                this.Y += this.mouseY;
                if (this.RotationDegrees == 0) {
                    if (this.X > WindowWidth) {
                        this.X = WindowWidth;
                    }
                    if (this.Y > WindowHeight) {
                        this.Y = WindowHeight;
                    }
                    if (this.X + this.lastWidth < 0.0) {
                        this.X = -this.lastWidth;
                    }
                    if (this.Y + this.lastHeight < 0.0) {
                        this.Y = -this.lastHeight;
                    }
                } else if (this.RotationDegrees == 1) {
                    if (this.X > WindowHeight) {
                        this.X = WindowHeight;
                    }
                    if (this.Y > 0.0) {
                        this.Y = 0.0;
                    }
                    if (this.X + tempHeight < 0.0) {
                        this.X = -tempHeight;
                    }
                    if (this.Y + tempWidth < -WindowWidth) {
                        this.Y = -WindowWidth - tempWidth;
                    }
                } else if (this.RotationDegrees == 2) {
                    if (this.X + this.lastWidth < -WindowWidth) {
                        this.X = -WindowWidth - this.lastWidth;
                    }
                    if (this.Y > 0.0) {
                        this.Y = 0.0;
                    }
                    if (this.X > 0.0) {
                        this.X = 0.0;
                    }
                    if (this.Y + this.lastHeight < -WindowHeight) {
                        this.Y = -WindowHeight - this.lastHeight;
                    }
                } else if (this.RotationDegrees == 3) {
                    if (this.X > 0.0) {
                        this.X = 0.0;
                    }
                    if (this.X + tempHeight < -WindowHeight) {
                        this.X = -WindowHeight - tempHeight;
                    }
                    if (this.Y > WindowWidth) {
                        this.Y = WindowWidth;
                    }
                    if (this.Y + tempWidth < 0.0) {
                        this.Y = -tempWidth;
                    }
                }
                graphics2D.drawImage(this.image, (int)this.X, (int)this.Y, (int)this.lastWidth, (int)this.lastHeight, null);
                this.mouseY = 0.0;
                this.mouseX = 0.0;
                this.lastRotationDegrees = this.RotationDegrees;
                this.isMove = false;
                this.lastPath = this.path;
                if (this.isEnableHardware) {
                    this.timer.start();
                }
                g.dispose();
                return;
            }
            if (this.RotationDegrees != this.lastRotationDegrees) {
                this.this$0.sizeOperate.setPercent(this.this$0.sizeOperate.getPictureOptimalSize());
                Point point = ImageRotationHelper.getRotatedCord((int)FinalX, (int)FinalY, 360 - 90 * this.RotationDegrees, (int)this.lastWidth, (int)this.lastHeight);
                FinalX = point.getX();
                FinalY = point.getY();
            }
            if (this.RotationDegrees == this.lastRotationDegrees && this.mouseX == 0.0 && this.mouseY == 0.0) {
                if (this.RotationDegrees == 0) {
                    this.mouseX = WindowWidth / 2.0;
                    this.mouseY = WindowHeight / 2.0;
                } else if (this.RotationDegrees == 1) {
                    this.mouseX = WindowHeight / 2.0;
                    this.mouseY = -(WindowWidth / 2.0);
                } else if (this.RotationDegrees == 2) {
                    this.mouseX = -(WindowWidth / 2.0);
                    this.mouseY = -(WindowHeight / 2.0);
                } else if (this.RotationDegrees == 3) {
                    this.mouseX = -(WindowHeight / 2.0);
                    this.mouseY = WindowWidth / 2.0;
                }
            }
            double PictureChangeRatio = 1.0;
            if (WindowWidth != 0.0 && WindowHeight != 0.0) {
                double WidthRatio = LastWindowWidth / WindowWidth;
                double HeightRatio = LastWindowHeight / WindowHeight;
                if (WidthRatio != 1.0 && HeightRatio != 1.0) {
                    PictureChangeRatio = (HeightRatio + WidthRatio) / 2.0;
                }
            }
            if (PictureChangeRatio == 0.0) {
                g.dispose();
                return;
            }
            double width = (double)this.getImageWidth() * this.this$0.sizeOperate.getPercent() / 100.0 * (1.0 / PictureChangeRatio);
            double height = width * (double)this.getImageHeight() / (double)this.getImageWidth();
            this.this$0.sizeOperate.setPercent(width * 100.0 / (double)this.getImageWidth());
            if (this.RotationDegrees % 2 == 0 && this.NewWindow != null && this.NewWindow.equals(this.LastWindow) && this.lastWidth != 0.0 && this.lastHeight != 0.0) {
                FinalX = width * (FinalX - this.mouseX) / this.lastWidth + this.mouseX;
                FinalY = height * (FinalY - this.mouseY) / this.lastHeight + this.mouseY;
            } else if (this.RotationDegrees % 2 == 1 && this.NewWindow != null && this.NewWindow.equals(this.LastWindow) && this.lastWidth != 0.0 && this.lastHeight != 0.0) {
                FinalX = height * (FinalX - this.mouseX) / this.lastHeight + this.mouseX;
                FinalY = width * (FinalY - this.mouseY) / this.lastWidth + this.mouseY;
            }
            if (this.RotationDegrees == 0) {
                if (WindowWidth <= width) {
                    if (FinalX > 0.0) {
                        FinalX = 0.0;
                    }
                    if (FinalX + width < WindowWidth) {
                        FinalX = WindowWidth - width;
                    }
                } else {
                    FinalX = (WindowWidth - width) / 2.0;
                }
                if (WindowHeight <= height) {
                    if (FinalY > 0.0) {
                        FinalY = 0.0;
                    }
                    if (FinalY + height < WindowHeight) {
                        FinalY = WindowHeight - height;
                    }
                } else {
                    FinalY = (WindowHeight - height) / 2.0;
                }
            } else if (this.RotationDegrees == 1) {
                if (WindowHeight <= width) {
                    if (FinalX > 0.0) {
                        FinalX = 0.0;
                    }
                    if (FinalX + width < WindowHeight) {
                        FinalX = WindowHeight - width;
                    }
                } else {
                    FinalX = (WindowHeight - width) / 2.0;
                }
                if (WindowWidth <= height) {
                    if (FinalY > -WindowWidth) {
                        FinalY = -WindowWidth;
                    }
                    if (FinalY < -height) {
                        FinalY = -height;
                    }
                } else {
                    FinalY = (-height - WindowWidth) / 2.0;
                }
            } else if (this.RotationDegrees == 2) {
                if (WindowWidth <= width) {
                    if (FinalX > -WindowWidth) {
                        FinalX = -WindowWidth;
                    }
                    if (FinalX < -width) {
                        FinalX = -width;
                    }
                } else {
                    FinalX = (-width - WindowWidth) / 2.0;
                }
                if (WindowHeight <= height) {
                    if (FinalY > -WindowHeight) {
                        FinalY = -WindowHeight;
                    }
                    if (FinalY < -height) {
                        FinalY = -height;
                    }
                } else {
                    FinalY = (-height - WindowHeight) / 2.0;
                }
            } else if (this.RotationDegrees == 3) {
                if (WindowHeight <= width) {
                    if (FinalX > -WindowHeight) {
                        FinalX = -WindowHeight;
                    }
                    if (FinalX < -width) {
                        FinalX = -width;
                    }
                } else {
                    FinalX = (-width - WindowHeight) / 2.0;
                }
                if (WindowWidth <= height) {
                    if (FinalY > 0.0) {
                        FinalY = 0.0;
                    }
                    if (FinalY + height < WindowWidth) {
                        FinalY = WindowWidth - height;
                    }
                } else {
                    FinalY = (WindowWidth - height) / 2.0;
                }
            }
            graphics2D.drawImage(this.image, (int)FinalX, (int)FinalY, (int)width, (int)height, null);
            if (PaintPicturePanel.paintPicture.enlargeButton != null) {
                PaintPicturePanel.paintPicture.enlargeButton.setEnabled(!PaintPicturePanel.paintPicture.sizeOperate.isTheBiggestRatio());
                if (!PaintPicturePanel.paintPicture.enlargeButton.isEnabled()) {
                    this.this$0.imageCanvas.requestFocus();
                }
            }
            if (PaintPicturePanel.paintPicture.reduceButton != null) {
                PaintPicturePanel.paintPicture.reduceButton.setEnabled(!PaintPicturePanel.paintPicture.sizeOperate.isTheSmallestRatio());
                if (!PaintPicturePanel.paintPicture.reduceButton.isEnabled()) {
                    this.this$0.imageCanvas.requestFocus();
                }
            }
            this.this$0.percentLabel.set((int)this.this$0.sizeOperate.getPercent());
            if (this.this$0.PercentSlider != null) {
                this.this$0.PercentSlider.setValue((int)this.this$0.sizeOperate.getPercent());
            }
            this.X = FinalX;
            this.Y = FinalY;
            this.LastWindow = this.NewWindow;
            this.LastPercent = this.this$0.sizeOperate.getPercent();
            this.lastWidth = width;
            this.lastHeight = height;
            this.lastRotationDegrees = this.RotationDegrees;
            this.mouseY = 0.0;
            this.mouseX = 0.0;
            this.lastPath = this.path;
            if (this.isEnableHardware) {
                this.timer.start();
            }
            g.dispose();
        }

        public void setIsMove(boolean isMove) {
            this.isMove = isMove;
        }

        public boolean getIsMove() {
            return this.isMove;
        }

        public void addCoordinate(int x, int y) {
            this.X += (double)x;
            this.Y += (double)y;
        }

        public void setDefaultCoordinate() {
            this.Y = 0.0;
            this.X = 0.0;
        }

        public void setX(int x) {
            this.X = x;
        }

        public void setMouseCoordinate(int mouseX, int mouseY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }

        public void setY(int y) {
            this.Y = y;
        }

        private void init_listener() {
            Robot robot = null;
            try {
                robot = new Robot();
            }
            catch (AWTException e) {
                log.warn("Couldn't get Mouse Information");
            }
            final Robot finalRobot = robot;
            final Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(0, 0, new int[0], 0, 0));
            final boolean[] EnableCursorDisplay = new boolean[1];
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ ImageCanvas this$1;
                {
                    ImageCanvas imageCanvas = this$1;
                    Objects.requireNonNull(imageCanvas);
                    this.this$1 = imageCanvas;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    this.this$1.this$0.op = new OperatingCoordinate(e.getX(), e.getY());
                    EnableCursorDisplay[0] = SettingsInfoHandle.getBoolean("EnableCursorDisplay", GUIStarter.main.centre.CurrentData);
                    if (EnableCursorDisplay[0]) {
                        return;
                    }
                    this.this$1.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), null));
                    this.this$1.this$0.mouseLocation = MouseInfo.getPointerInfo().getLocation();
                    if (this.this$1.this$0.ShowingSize != null && this.this$1.this$0.LocationOnScreen != null && this.this$1.this$0.ShowingSize.equals(this.this$1.this$0.sizeOperate.getWindowSize()) && this.this$1.this$0.LocationOnScreen.equals(this.this$1.this$0.imageCanvas.getLocationOnScreen())) {
                        return;
                    }
                    this.this$1.this$0.LocationOnScreen = this.this$1.this$0.imageCanvas.getLocationOnScreen();
                    this.this$1.this$0.ShowingSize = this.this$1.this$0.sizeOperate.getWindowSize();
                    int minX = -this.this$1.this$0.LocationOnScreen.x;
                    int minY = -this.this$1.this$0.LocationOnScreen.y;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (minY < 0) {
                        minY = 0;
                    }
                    this.this$1.this$0.MinPoint = new Point(minX, minY);
                    int maxX = this.this$1.this$0.ShowingSize.width;
                    int maxY = this.this$1.this$0.ShowingSize.height;
                    int x = this.this$1.this$0.ShowingSize.width + this.this$1.this$0.LocationOnScreen.x;
                    int y = this.this$1.this$0.ShowingSize.height + this.this$1.this$0.LocationOnScreen.y;
                    if (x > SizeOperate.FreeOfScreenSize.width) {
                        maxX = SizeOperate.FreeOfScreenSize.width - this.this$1.this$0.LocationOnScreen.x;
                    }
                    if (y > SizeOperate.FreeOfScreenSize.height) {
                        maxY = SizeOperate.FreeOfScreenSize.height - this.this$1.this$0.LocationOnScreen.y;
                    }
                    this.this$1.this$0.MaxPoint = new Point(maxX, maxY);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (!EnableCursorDisplay[0]) {
                        this.this$1.setCursor(Cursor.getDefaultCursor());
                        if (finalRobot != null) {
                            finalRobot.mouseMove(this.this$1.this$0.mouseLocation.x, this.this$1.this$0.mouseLocation.y);
                        }
                    }
                }
            });
            PaintPicturePanel.paintPicture.mouseAdapter = new MouseAdapter(this){
                final /* synthetic */ ImageCanvas this$1;
                {
                    ImageCanvas imageCanvas = this$1;
                    Objects.requireNonNull(imageCanvas);
                    this.this$1 = imageCanvas;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    int x = e.getX();
                    int y = e.getY();
                    if (!EnableCursorDisplay[0]) {
                        boolean NeedToMove = false;
                        if (x <= this.this$1.this$0.MinPoint.x) {
                            x = this.this$1.this$0.MaxPoint.x - 2;
                            NeedToMove = true;
                        } else if (x >= this.this$1.this$0.MaxPoint.x - 1) {
                            x = this.this$1.this$0.MinPoint.x + 1;
                            NeedToMove = true;
                        }
                        if (y <= this.this$1.this$0.MinPoint.y) {
                            y = this.this$1.this$0.MaxPoint.y - 2;
                            NeedToMove = true;
                        } else if (y >= this.this$1.this$0.MaxPoint.y - 1) {
                            y = this.this$1.this$0.MinPoint.y + 1;
                            NeedToMove = true;
                        }
                        if (NeedToMove) {
                            this.this$1.this$0.op = new OperatingCoordinate(x, y);
                            Point point = this.this$1.this$0.imageCanvas.getLocationOnScreen();
                            if (finalRobot != null) {
                                finalRobot.mouseMove(x + point.x, y + point.y);
                            }
                            return;
                        }
                    }
                    this.this$1.this$0.imageCanvas.setMouseCoordinate((int)((1.0 + SettingsInfoHandle.getDouble("MouseMoveOffsets", GUIStarter.main.centre.CurrentData) / 100.0) * (double)(x - this.this$1.this$0.op.x())), (int)((1.0 + SettingsInfoHandle.getDouble("MouseMoveOffsets", GUIStarter.main.centre.CurrentData) / 100.0) * (double)(y - this.this$1.this$0.op.y())));
                    this.this$1.this$0.sizeOperate.update(true);
                    this.this$1.this$0.op = new OperatingCoordinate(x, y);
                }
            };
            this.addMouseMotionListener(PaintPicturePanel.paintPicture.mouseAdapter);
            this.addMouseWheelListener(new MouseAdapter(this){
                final /* synthetic */ ImageCanvas this$1;
                {
                    ImageCanvas imageCanvas = this$1;
                    Objects.requireNonNull(imageCanvas);
                    this.this$1 = imageCanvas;
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (e.getWheelRotation() == 1) {
                        if (this.this$1.this$0.sizeOperate.adjustPercent(1) || this.this$1.this$0.sizeOperate.adjustPercent(1)) {
                            this.this$1.this$0.imageCanvas.setMouseCoordinate(e.getX(), e.getY());
                            this.this$1.this$0.sizeOperate.update(false);
                        }
                    } else if (e.getWheelRotation() == -1 && (this.this$1.this$0.sizeOperate.adjustPercent(0) || this.this$1.this$0.sizeOperate.adjustPercent(0))) {
                        this.this$1.this$0.imageCanvas.setMouseCoordinate(e.getX(), e.getY());
                        this.this$1.this$0.sizeOperate.update(false);
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(this){
                final /* synthetic */ ImageCanvas this$1;
                {
                    ImageCanvas imageCanvas = this$1;
                    Objects.requireNonNull(imageCanvas);
                    this.this$1 = imageCanvas;
                }

                @Override
                public synchronized void keyReleased(KeyEvent e) {
                    int KeyCode = e.getKeyCode();
                    switch (KeyCode) {
                        case 27: {
                            if (!this.this$1.this$0.fullScreenWindow.isShowing()) break;
                            this.this$1.setFullScreen(false);
                            return;
                        }
                        case 122: {
                            this.this$1.setFullScreen(!this.this$1.this$0.fullScreenWindow.isShowing());
                            return;
                        }
                    }
                    this.this$1.this$0.imageCanvas.openLONPicture(KeyCode);
                }
            });
        }

        public void setFullScreen(boolean fullScreen) {
            if (this.this$0.imageCanvas == null || this.this$0.fullScreenWindow == null || GUIStarter.main == null || this.this$0.sizeOperate == null || paintPicture == null) {
                return;
            }
            if (fullScreen == this.this$0.fullScreenWindow.isShowing() && fullScreen != GUIStarter.main.isShowing()) {
                return;
            }
            if (fullScreen) {
                this.this$0.fullScreenWindow.setImageCanvas(this.this$0.imageCanvas);
                GUIStarter.main.getGraphics().dispose();
            } else {
                PaintPicturePanel.paintPicture.MainPanel.add((Component)this.this$0.imageCanvas, "Center");
            }
            GUIStarter.main.setVisible(!fullScreen);
            this.this$0.fullScreenWindow.setVisible(fullScreen);
            this.this$0.sizeOperate.incomeWindowDimension(this.this$0.imageCanvas.getSize());
            this.this$0.sizeOperate.update(false);
            this.setCursor(Cursor.getDefaultCursor());
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String getPicture_hashcode() {
            return this.picture_hashcode;
        }

        @Generated
        public boolean isLowOccupancyMode() {
            return this.isLowOccupancyMode;
        }
    }
}

