/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.NComponent.Component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import lombok.Generated;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.GUIStarter;
import top.nserly.SoftwareCollections_API.OSInformation.SystemMonitor;
import top.nserly.SoftwareCollections_API.Queue.ThreadPoolTaskQueue;

public class ThumbnailPreviewOfImage
extends JComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThumbnailPreviewOfImage.class);
    private static final Map<String, SoftReference<BufferedImage>> THUMBNAIL_CACHE = new ConcurrentHashMap<String, SoftReference<BufferedImage>>();
    private static final ThreadPoolTaskQueue loadingPictureTaskQueue = new ThreadPoolTaskQueue(SystemMonitor.CPU_Physical_Core_Count, SystemMonitor.CPU_Logical_Thread_Count);
    private final MouseAdapter mouseAdapter;
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    private BufferedImage image;
    private Future<?> loadTask;

    public ThumbnailPreviewOfImage(final String filePath) {
        this.mouseAdapter = new MouseAdapter(this){
            final /* synthetic */ ThumbnailPreviewOfImage this$0;
            {
                ThumbnailPreviewOfImage thumbnailPreviewOfImage = this$0;
                Objects.requireNonNull(thumbnailPreviewOfImage);
                this.this$0 = thumbnailPreviewOfImage;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.this$0.isDisposed.get()) {
                    return;
                }
                GUIStarter.main.textField1.setText(filePath);
                if (e.getClickCount() >= 2) {
                    GUIStarter.main.openPicture(filePath);
                }
            }
        };
        this.addMouseListener(this.mouseAdapter);
        this.setToolTipText(filePath);
        SoftReference<BufferedImage> cacheRef = THUMBNAIL_CACHE.get(filePath);
        if (cacheRef != null && cacheRef.get() != null) {
            this.image = cacheRef.get();
            if (this.image != null) {
                this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
            }
            this.repaint();
            return;
        }
        this.loadTask = loadingPictureTaskQueue.addTask(() -> {
            if (this.isDisposed.get() || this.loadTask != null && this.loadTask.isCancelled()) {
                return;
            }
            try {
                BufferedImage tempImage = Thumbnails.of((String[])new String[]{filePath}).size(80, 80).outputFormat("jpg").outputQuality(0.7f).imageType(5).allowOverwrite(true).asBufferedImage();
                if (this.isDisposed.get() || this.loadTask != null && this.loadTask.isCancelled()) {
                    if (tempImage != null) {
                        tempImage.flush();
                    }
                    return;
                }
                THUMBNAIL_CACHE.put(filePath, new SoftReference<BufferedImage>(tempImage));
                BufferedImage finalTempImage = tempImage;
                SwingUtilities.invokeLater(() -> {
                    if (!this.isDisposed.get()) {
                        this.image = finalTempImage;
                        this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
                        this.repaint();
                    } else if (finalTempImage != null) {
                        finalTempImage.flush();
                    }
                });
            }
            catch (IOException e) {
                log.error("Failed to load the thumbnail: {}", (Object)filePath, (Object)e);
            }
        });
    }

    public static boolean isCompleteLoading() {
        return loadingPictureTaskQueue.getActiveThreadCount() == 0 && loadingPictureTaskQueue.getPendingTaskCount() == 0;
    }

    public static void waitTillCompleteLoading() throws InterruptedException {
        ThumbnailPreviewOfImage.waitTillCompleteLoading(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitTillCompleteLoading(long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        long remaining = timeout;
        while (!ThumbnailPreviewOfImage.isCompleteLoading()) {
            if (timeout > 0L && (remaining = timeout - (System.currentTimeMillis() - start)) <= 0L) {
                return false;
            }
            ThreadPoolTaskQueue threadPoolTaskQueue = loadingPictureTaskQueue;
            synchronized (threadPoolTaskQueue) {
                loadingPictureTaskQueue.wait(Math.min(250L, remaining > 0L ? remaining : 250L));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyLoadingStateChanged() {
        ThreadPoolTaskQueue threadPoolTaskQueue = loadingPictureTaskQueue;
        synchronized (threadPoolTaskQueue) {
            loadingPictureTaskQueue.notifyAll();
        }
    }

    public void dispose() {
        if (this.isDisposed.compareAndSet(false, true)) {
            if (this.loadTask != null) {
                this.loadTask.cancel(true);
                this.loadTask = null;
            }
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.removeMouseListener(this.mouseAdapter);
            this.removeAll();
            this.setUI(null);
            this.setToolTipText(null);
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.isDisposed.get()) {
            return;
        }
        super.paint(g);
        if (this.image == null) {
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
    }

    @Generated
    public MouseAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    @Generated
    public AtomicBoolean getIsDisposed() {
        return this.isDisposed;
    }

    @Generated
    public BufferedImage getImage() {
        return this.image;
    }

    @Generated
    public Future<?> getLoadTask() {
        return this.loadTask;
    }

    static {
        try (ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();){
            scheduler.scheduleAtFixedRate(() -> {
                THUMBNAIL_CACHE.entrySet().removeIf(entry -> ((SoftReference)entry.getValue()).get() == null);
                log.debug("Clean up the invalid thumbnail cache, the current cache size: {}", (Object)THUMBNAIL_CACHE.size());
            }, 5L, 5L, TimeUnit.MINUTES);
        }
    }
}

