/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.NComponent.Frame;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import lombok.Generated;
import top.nserly.GUIStarter;
import top.nserly.PicturePlayer.Loading.Bundle;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.GetImageInformation;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageDPI.ImageDPI;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageDPI.ImageDPIGetter;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageHandle;
import top.nserly.PicturePlayer.Utils.Window.WindowLocation;
import top.nserly.SoftwareCollections_API.FileHandle.ComputeFileSize;

public class PictureInformationViewer
extends JDialog {
    private JPanel panel1;
    private JTextField PictureNameTextField;
    private JLabel PictureSizeInfoLabel;
    private JLabel PictureTypeInfoLabel;
    private JLabel PictureResolutionInfoLabel;
    private JLabel PictureDPIInfoLabel;
    private JLabel PictureBitDepthInfoLabel;
    private JLabel PicturePathInfoLabel;
    private JScrollPane MainPanel;
    private String picturePath;
    private Frame owner;
    private static Method $$$cachedGetBundleMethod$$$ = null;

    public PictureInformationViewer(Frame owner) {
        super(owner, true);
        this.$$$setupUI$$$();
        this.owner = owner;
        SwingUtilities.invokeLater(() -> {
            this.setTitle(Bundle.getMessage("PictureViewer_Title"));
            this.setIconImage(GUIStarter.SOFTWARE_FRAME_ICON);
            this.setLayout(new BorderLayout());
            this.add((Component)this.MainPanel, "Center");
            this.setSize(630, 350);
            this.PictureNameTextField.addActionListener(e -> {});
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocation(WindowLocation.componentCenter(this.owner, this.getWidth(), this.getHeight()));
        }
        super.setVisible(visible);
    }

    private void $$$setupUI$$$() {
        this.MainPanel = new JScrollPane();
        this.panel1 = new JPanel();
        this.panel1.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.panel1.setRequestFocusEnabled(false);
        this.MainPanel.setViewportView(this.panel1);
        Spacer spacer1 = new Spacer();
        this.panel1.add((Component)spacer1, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        Font label1Font = this.$$$getFont$$$(null, -1, 12, label1.getFont());
        if (label1Font != null) {
            label1.setFont(label1Font);
        }
        label1.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(label1, this.$$$getMessageFromBundle$$$("messages", "PictureInfoViewer_PictureNameLabel"));
        this.panel1.add((Component)label1, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        Font label2Font = this.$$$getFont$$$(null, -1, 20, label2.getFont());
        if (label2Font != null) {
            label2.setFont(label2Font);
        }
        label2.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(label2, this.$$$getMessageFromBundle$$$("messages", "PictureInfoViewer_Title"));
        this.panel1.add((Component)label2, new GridConstraints(0, 0, 1, 2, 0, 0, 0, 0, null, null, null, 0, false));
        this.PictureNameTextField = new JTextField();
        this.PictureNameTextField.setRequestFocusEnabled(false);
        this.panel1.add((Component)this.PictureNameTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label3 = new JLabel();
        Font label3Font = this.$$$getFont$$$(null, -1, 12, label3.getFont());
        if (label3Font != null) {
            label3.setFont(label3Font);
        }
        label3.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(label3, this.$$$getMessageFromBundle$$$("messages", "PictureInfoViewer_PictureSizeLabel"));
        this.panel1.add((Component)label3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.PictureSizeInfoLabel = new JLabel();
        this.PictureSizeInfoLabel.setRequestFocusEnabled(false);
        this.PictureSizeInfoLabel.setText("");
        this.panel1.add((Component)this.PictureSizeInfoLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        Font label4Font = this.$$$getFont$$$(null, -1, 12, label4.getFont());
        if (label4Font != null) {
            label4.setFont(label4Font);
        }
        label4.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(label4, this.$$$getMessageFromBundle$$$("messages", "PictureInfoViewer_PictureTypeLabel"));
        this.panel1.add((Component)label4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.PictureTypeInfoLabel = new JLabel();
        this.PictureTypeInfoLabel.setRequestFocusEnabled(false);
        this.PictureTypeInfoLabel.setText("");
        this.panel1.add((Component)this.PictureTypeInfoLabel, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(label5, this.$$$getMessageFromBundle$$$("messages", "PictureInfoViewer_PictureResolutionLabel"));
        this.panel1.add((Component)label5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.PictureResolutionInfoLabel = new JLabel();
        this.PictureResolutionInfoLabel.setRequestFocusEnabled(false);
        this.PictureResolutionInfoLabel.setText("");
        this.panel1.add((Component)this.PictureResolutionInfoLabel, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label6 = new JLabel();
        Font label6Font = this.$$$getFont$$$(null, -1, 12, label6.getFont());
        if (label6Font != null) {
            label6.setFont(label6Font);
        }
        label6.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(label6, this.$$$getMessageFromBundle$$$("messages", "PictureInfoViewer_PictureDPILabel"));
        this.panel1.add((Component)label6, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label7 = new JLabel();
        label7.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(label7, this.$$$getMessageFromBundle$$$("messages", "PictureInfoViewer_PictureBitDepth"));
        this.panel1.add((Component)label7, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.PictureDPIInfoLabel = new JLabel();
        this.PictureDPIInfoLabel.setRequestFocusEnabled(false);
        this.PictureDPIInfoLabel.setText("");
        this.panel1.add((Component)this.PictureDPIInfoLabel, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.PictureBitDepthInfoLabel = new JLabel();
        this.PictureBitDepthInfoLabel.setRequestFocusEnabled(false);
        this.PictureBitDepthInfoLabel.setText("");
        this.panel1.add((Component)this.PictureBitDepthInfoLabel, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label8 = new JLabel();
        label8.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(label8, this.$$$getMessageFromBundle$$$("messages", "PictureInfoViewer_PicturePathLabel"));
        this.panel1.add((Component)label8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.PicturePathInfoLabel = new JLabel();
        this.PicturePathInfoLabel.setRequestFocusEnabled(false);
        this.PicturePathInfoLabel.setText("");
        this.panel1.add((Component)this.PicturePathInfoLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    private String $$$getMessageFromBundle$$$(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if ($$$cachedGetBundleMethod$$$ == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                $$$cachedGetBundleMethod$$$ = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)$$$cachedGetBundleMethod$$$.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.MainPanel;
    }

    public synchronized void update(ImageHandle imageHandle) throws IOException {
        this.picturePath = imageHandle.path();
        File file = new File(this.picturePath);
        Dimension resolution = GetImageInformation.getImageResolution(imageHandle.imageReader());
        ImageDPI DPI = ImageDPIGetter.getImageDPI(imageHandle.path());
        int AverageDPI = Math.round((DPI.HorizontalDPI() + DPI.VerticalDPI()) / 2.0f);
        this.PictureNameTextField.setText(file.getName());
        this.PictureSizeInfoLabel.setText(ComputeFileSize.formatFileSize(ComputeFileSize.computeFileSize(file, 2)));
        this.PictureTypeInfoLabel.setText(GetImageInformation.getImageType(imageHandle.imageReader()));
        this.PictureResolutionInfoLabel.setText(resolution.width + " x " + resolution.height);
        this.PictureDPIInfoLabel.setText(AverageDPI + " dpi");
        this.PictureBitDepthInfoLabel.setText(GetImageInformation.getBitDepth(imageHandle.path()) + " bit");
        this.PicturePathInfoLabel.setText(file.getAbsolutePath());
    }

    @Generated
    public String getPicturePath() {
        return this.picturePath;
    }

    @Generated
    public void setOwner(Frame owner) {
        this.owner = owner;
    }
}

