/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.NComponent.Frame;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import top.nserly.GUIStarter;
import top.nserly.PicturePlayer.Loading.Bundle;
import top.nserly.PicturePlayer.NComponent.Frame.AddProxyServerFrame;
import top.nserly.PicturePlayer.Utils.ProxyServer.ProxyServerHandle;
import top.nserly.PicturePlayer.Utils.Window.WindowLocation;
import top.nserly.SoftwareCollections_API.String.StringFormation;

public class ProxyServerChooser
extends JDialog {
    private final AddProxyServerFrame addProxyServer;
    private final StringFormation formation = new StringFormation(Bundle.getMessage("AddProxyServer_ErrorMessage_Content"));
    private JPanel contentPane;
    private JButton ChooseThisProxyServerButton;
    private JButton AddProxyServerButton;
    private JButton EditProxyServerButton;
    private JButton DeleteProxyServerButton;
    private JButton CancelProxyServerButton;
    private JButton RefreshProxyServerButton;
    private JTable ProxyServerTable;
    DefaultTableModel tableModel = new DefaultTableModel();
    public static final String[] columnNames = new String[]{Bundle.getMessage("ProxyServer_TableFirst"), Bundle.getMessage("ProxyServer_TableSecond")};
    public ProxyServerHandle handle;
    private static Method $$$cachedGetBundleMethod$$$ = null;

    public ProxyServerChooser() {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.ChooseThisProxyServerButton);
        this.handle = new ProxyServerHandle("data\\ProxyServerMenu.pxs");
        this.addProxyServer = new AddProxyServerFrame(this);
        this.refresh(false);
        this.ChooseThisProxyServerButton.addActionListener(e -> this.choice());
        this.AddProxyServerButton.addActionListener(e -> this.add());
        this.EditProxyServerButton.addActionListener(e -> {
            int row = this.ProxyServerTable.getSelectedRow();
            this.edit(row);
        });
        this.DeleteProxyServerButton.addActionListener(e -> {
            int[] rows = this.ProxyServerTable.getSelectedRows();
            if (rows.length > 0 && JOptionPane.showConfirmDialog(this, Bundle.getMessage("ProxyServer_Delete_Content"), Bundle.getMessage("ProxyServer_Delete_Title"), 0) == 0) {
                this.delete(rows);
            }
        });
        this.CancelProxyServerButton.addActionListener(e -> this.cancel());
        this.RefreshProxyServerButton.addActionListener(e -> this.refresh(true));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ProxyServerChooser this$0;
            {
                ProxyServerChooser proxyServerChooser = this$0;
                Objects.requireNonNull(proxyServerChooser);
                this.this$0 = proxyServerChooser;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.cancel();
            }
        });
        this.contentPane.registerKeyboardAction(e -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void choice() {
        String str;
        int row = this.ProxyServerTable.getSelectedRow();
        if (row != -1 && (str = (String)this.tableModel.getValueAt(row, 0)) != null && !str.trim().isEmpty()) {
            this.setVisible(false);
            this.handle.setCurrentSelectionProxyServerName(str);
            GUIStarter.main.setProxyServerOfInit(this.handle.getProxyServerAddress(str));
            this.handle.save();
        }
    }

    private void cancel() {
        this.setVisible(false);
    }

    public void refresh(boolean isSetRowSelectionInterval) {
        this.ProxyServerTable.getSelectionModel().clearSelection();
        this.handle.refresh();
        this.tableModel.setRowCount(0);
        this.handle.getAllProxyServerNames().forEach(this::addElement);
        if (isSetRowSelectionInterval) {
            this.setProxyServerSelected();
        }
    }

    public void setProxyServerSelected() {
        String ProxyServerName = this.handle.getCurrentSelectionProxyServerName();
        if (this.handle.containsProxyServerName(ProxyServerName)) {
            this.setRowSelectionInterval(this.findRowIndexByColumnContent(0, ProxyServerName));
        }
    }

    private void addElement(String ProxyServerName) {
        this.tableModel.addRow(new String[]{ProxyServerName, this.handle.getProxyServerAddress(ProxyServerName)});
    }

    private void addElement(String ProxyServerName, String ProxyServerAddress) {
        this.tableModel.addRow(new String[]{ProxyServerName, ProxyServerAddress});
    }

    private void add() {
        this.addProxyServer.pack();
        this.addProxyServer.loadInformationAndVisible(-1);
    }

    private void edit(int rowIndex) {
        if (rowIndex == -1) {
            return;
        }
        String ProxyServerName = (String)this.tableModel.getValueAt(rowIndex, 0);
        this.addProxyServer.ProxyServerNameTextField.setText(ProxyServerName);
        this.addProxyServer.ProxyServerAddressTextField.setText(this.handle.getProxyServerAddress(ProxyServerName));
        this.addProxyServer.pack();
        this.addProxyServer.loadInformationAndVisible(rowIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNewProxyServer(String ProxyServerName, String ProxyServerAddress, int rowIndex) {
        if (ProxyServerAddress.isBlank()) {
            return;
        }
        boolean isExist = this.handle.containsProxyServerName(ProxyServerName);
        String string = ProxyServerName = ProxyServerName.isBlank() ? ProxyServerAddress : ProxyServerName;
        if (rowIndex < 0) {
            if (!isExist) {
                this.addElement(ProxyServerName, ProxyServerAddress);
            } else {
                if (this.handle.getProxyServerAddress(ProxyServerName).equals(ProxyServerAddress)) {
                    return;
                }
                this.formation.add("originalProxyServerAddress", this.handle.getProxyServerAddress(ProxyServerName));
                this.formation.add("newProxyServerAddress", ProxyServerAddress);
                if (JOptionPane.showConfirmDialog(this, this.formation.getProcessingString(), Bundle.getMessage("AddProxyServer_ErrorMessage_Title"), 0) != 0) return;
                this.handle.delete(ProxyServerName);
                this.tableModel.setValueAt(ProxyServerAddress, this.findRowIndexByColumnContent(0, ProxyServerName), 1);
            }
        } else {
            this.handle.delete((String)this.tableModel.getValueAt(rowIndex, 0));
            this.tableModel.setValueAt(ProxyServerName, rowIndex, 0);
            this.tableModel.setValueAt(ProxyServerAddress, rowIndex, 1);
        }
        this.handle.add(ProxyServerName, ProxyServerAddress);
        this.handle.save();
        this.addProxyServer.clear();
    }

    public void delete(int rowIndex) {
        if (rowIndex >= this.tableModel.getRowCount()) {
            return;
        }
        this.handle.delete((String)this.tableModel.getValueAt(rowIndex, 0));
        this.tableModel.removeRow(rowIndex);
        this.handle.save();
    }

    public void delete(int[] rowIndex) {
        for (int i = 0; i < rowIndex.length - 1; ++i) {
            for (int j = 0; j < rowIndex.length - 1 - i; ++j) {
                if (rowIndex[j] >= rowIndex[j + 1]) continue;
                int temp = rowIndex[j];
                rowIndex[j] = rowIndex[j + 1];
                rowIndex[j + 1] = temp;
            }
        }
        for (int i : rowIndex) {
            this.delete(i);
        }
    }

    public int findRowIndexByColumnContent(int columnIndex, String content) {
        Vector<Vector> dataVector = this.tableModel.getDataVector();
        if (columnIndex < 0 || dataVector.isEmpty()) {
            return -1;
        }
        for (int rowIdx = 0; rowIdx < dataVector.size(); ++rowIdx) {
            Object cellValue;
            Vector rowData = dataVector.get(rowIdx);
            if (columnIndex >= rowData.size() || !content.equals(cellValue = rowData.get(columnIndex))) continue;
            return rowIdx;
        }
        return -1;
    }

    private void setRowSelectionInterval(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.ProxyServerTable.getRowCount() - 1) {
            return;
        }
        this.ProxyServerTable.setRowSelectionInterval(rowIndex, rowIndex);
        this.ProxyServerTable.scrollRectToVisible(this.ProxyServerTable.getCellRect(rowIndex, 0, true));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setProxyServerSelected();
        }
        this.setLocation(WindowLocation.componentCenter(GUIStarter.main, this.getWidth(), this.getHeight()));
        super.setVisible(visible);
    }

    private void createUIComponents() {
        this.tableModel = new DefaultTableModel(this, new String[0][], columnNames){
            final /* synthetic */ ProxyServerChooser this$0;
            {
                ProxyServerChooser proxyServerChooser = this$0;
                Objects.requireNonNull(proxyServerChooser);
                this.this$0 = proxyServerChooser;
                super(data, columnNames);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.ProxyServerTable = new JTable(this.tableModel);
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        this.ProxyServerTable.getInputMap(1).put(enterKey, "none");
        this.ProxyServerTable.addPropertyChangeListener("tableCellEditor", evt -> {
            Component editorComp;
            if (this.ProxyServerTable.isEditing() && (editorComp = this.ProxyServerTable.getEditorComponent()) instanceof JTextComponent) {
                JTextComponent textComp = (JTextComponent)editorComp;
                textComp.getInputMap().put(enterKey, new KeyAdapter(this){
                    final /* synthetic */ ProxyServerChooser this$0;
                    {
                        ProxyServerChooser proxyServerChooser = this$0;
                        Objects.requireNonNull(proxyServerChooser);
                        this.this$0 = proxyServerChooser;
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                        this.this$0.choice();
                    }
                });
            }
        });
        this.ProxyServerTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ProxyServerChooser this$0;
            {
                ProxyServerChooser proxyServerChooser = this$0;
                Objects.requireNonNull(proxyServerChooser);
                this.this$0 = proxyServerChooser;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    this.this$0.choice();
                }
            }
        });
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        this.contentPane.setToolTipText("");
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.ChooseThisProxyServerButton = new JButton();
        this.ChooseThisProxyServerButton.setHorizontalTextPosition(0);
        this.ChooseThisProxyServerButton.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.ChooseThisProxyServerButton, this.$$$getMessageFromBundle$$$("messages", "ChooseThisProxyServerButton"));
        panel2.add((Component)this.ChooseThisProxyServerButton, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, false));
        this.AddProxyServerButton = new JButton();
        this.AddProxyServerButton.setHorizontalTextPosition(0);
        this.AddProxyServerButton.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.AddProxyServerButton, this.$$$getMessageFromBundle$$$("messages", "AddProxyServerButton"));
        panel2.add((Component)this.AddProxyServerButton, new GridConstraints(0, 2, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
        this.EditProxyServerButton = new JButton();
        this.EditProxyServerButton.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.EditProxyServerButton, this.$$$getMessageFromBundle$$$("messages", "EditProxyServerButton"));
        panel2.add((Component)this.EditProxyServerButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.DeleteProxyServerButton = new JButton();
        this.DeleteProxyServerButton.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.DeleteProxyServerButton, this.$$$getMessageFromBundle$$$("messages", "DeleteProxyServerButton"));
        panel2.add((Component)this.DeleteProxyServerButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.CancelProxyServerButton = new JButton();
        this.CancelProxyServerButton.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.CancelProxyServerButton, this.$$$getMessageFromBundle$$$("messages", "CancelProxyServerButton"));
        panel2.add((Component)this.CancelProxyServerButton, new GridConstraints(1, 3, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.RefreshProxyServerButton = new JButton();
        this.RefreshProxyServerButton.setRequestFocusEnabled(false);
        this.$$$loadButtonText$$$(this.RefreshProxyServerButton, this.$$$getMessageFromBundle$$$("messages", "RefreshProxyServerButton"));
        panel2.add((Component)this.RefreshProxyServerButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setRequestFocusEnabled(false);
        scrollPane1.setToolTipText("");
        panel3.add((Component)scrollPane1, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        scrollPane1.setViewportView(this.ProxyServerTable);
    }

    private String $$$getMessageFromBundle$$$(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if ($$$cachedGetBundleMethod$$$ == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                $$$cachedGetBundleMethod$$$ = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)$$$cachedGetBundleMethod$$$.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

