/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Settings;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.GUIStarter;
import top.nserly.PicturePlayer.Loading.DefaultArgs;

public class SettingsInfoHandle {
    public static final Map<String, String> DefaultData = new HashMap<String, String>();
    public final HashMap<String, String> CurrentData = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(SettingsInfoHandle.class);

    public SettingsInfoHandle() {
        this.reFresh();
    }

    public void setDefault() {
        this.CurrentData.clear();
        this.CurrentData.putAll(DefaultData);
    }

    public void reFresh() {
        this.setDefault();
        try {
            GUIStarter.init.run();
            Properties properties = GUIStarter.init.getProperties();
            for (Object obj : properties.keySet()) {
                if (!DefaultData.containsKey((String)obj)) continue;
                this.CurrentData.replace((String)obj, (String)properties.get(obj));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static boolean getBoolean(String Description, Map<?, ?> map) {
        if (map == null || !map.containsKey(Description)) {
            if (DefaultData.containsKey(Description)) {
                return Boolean.parseBoolean(DefaultData.get(Description));
            }
            return false;
        }
        return Boolean.parseBoolean(map.get(Description).toString().trim().toLowerCase());
    }

    public static double getDouble(String Description, Map<?, ?> map) {
        return SettingsInfoHandle.getDouble(Description, map, -65.0, 150.0);
    }

    public static int getInt(String Description, Map<?, ?> map) {
        if (map == null || !map.containsKey(Description)) {
            if (DefaultData.containsKey(Description)) {
                return Integer.parseInt(DefaultData.get(Description));
            }
            return -1;
        }
        return Integer.parseInt(map.get(Description).toString().trim().toLowerCase());
    }

    private static double getDouble(String Description, Map<?, ?> map, double min, double max) {
        if (min > max) {
            double temp = max;
            max = min;
            min = temp;
        }
        String cache = map.get(Description).toString().replace(" ", "");
        double result = 0.0;
        try {
            result = Double.parseDouble(cache);
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage());
        }
        if (result > max) {
            result = max;
        }
        if (result < min) {
            result = min;
        }
        return result;
    }

    public void save() {
        GUIStarter.init.writer(this.CurrentData);
    }

    static {
        try {
            Method[] methods;
            Class<DefaultArgs> clazz = DefaultArgs.class;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (method.getName().equals("annotationType") || method.isDefault()) continue;
                String defaultValue = method.getDefaultValue().toString();
                DefaultData.put(method.getName(), defaultValue);
            }
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage());
        }
    }
}

