/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Size;

import java.awt.Dimension;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.PicturePlayer.NComponent.Component.PaintPicturePanel;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.ScreenManager;

public class SizeOperate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SizeOperate.class);
    private final short Default;
    public static final int Enlarge = 0;
    public static final int Reduce = 1;
    private double percent;
    public final short MaxPercent = (short)1500;
    public final short MinPercent = (short)2;
    private PaintPicturePanel.ImageCanvas imageCanvas;
    private Dimension Component;
    public double FittestPercent;
    private int AdjustPercent;
    private Dimension PictureSize;
    public static final Dimension ScreenSize = ScreenManager.getPrimaryScreen().screenSize();
    public static final Dimension FreeOfScreenSize = ScreenManager.getPrimaryScreen().usableScreenSize();

    public SizeOperate(PaintPicturePanel.ImageCanvas imageCanvas, Dimension Component2) {
        this.Component = Component2;
        this.imageCanvas = imageCanvas;
        this.Default = (short)100;
        this.FittestPercent = this.percent = (double)100;
    }

    public SizeOperate(PaintPicturePanel.ImageCanvas imageCanvas, short defaultPercent, Dimension Component2) {
        this.imageCanvas = imageCanvas;
        this.Default = defaultPercent;
        this.FittestPercent = this.percent = (double)this.Default;
        this.Component = Component2;
    }

    public void changeCanvas(PaintPicturePanel.ImageCanvas imageCanvas, boolean isRestoreFittest) {
        this.imageCanvas = imageCanvas;
        if (imageCanvas.getPath() != null) {
            this.PictureSize = new Dimension(imageCanvas.getImageWidth(), imageCanvas.getImageHeight());
            if (this.Component != null) {
                this.AdjustPercent = (int)((Math.abs(this.Component.getHeight() - (double)this.PictureSize.height) / 5.5 / (double)this.PictureSize.height + Math.abs(this.Component.getWidth() - (double)this.PictureSize.width) / 5.5 / (double)this.PictureSize.width) / 2.0);
            }
        }
        this.FittestPercent = this.getPictureOptimalSize();
        if (isRestoreFittest) {
            this.setPercent(this.FittestPercent);
            this.update(false);
        }
    }

    public Dimension getWindowSize() {
        return this.Component;
    }

    public int getWindowHeight() {
        return this.Component.height;
    }

    public int getWindowWight() {
        return this.Component.height;
    }

    public void incomeWindowDimension(Dimension window) {
        if (window != null) {
            this.Component = window;
            this.FittestPercent = this.getPictureOptimalSize();
            if (this.PictureSize == null && this.imageCanvas != null) {
                try {
                    this.PictureSize = new Dimension(this.imageCanvas.getImageWidth(), this.imageCanvas.getImageHeight());
                }
                catch (Exception e) {
                    log.warn("Could not get picture size");
                    log.warn(ExceptionHandler.getExceptionMessage(e));
                    return;
                }
                this.AdjustPercent = (int)((Math.abs(window.getHeight() - (double)this.PictureSize.height) / 5.5 / (double)this.PictureSize.height + Math.abs(window.getWidth() - (double)this.PictureSize.width) / 5.5 / (double)this.PictureSize.width) / 2.0);
            }
        }
    }

    public short getDefaultPercent() {
        return this.Default;
    }

    private double decide(double size) {
        double result = size > 1500.0 ? 1500.0 : size;
        if (size < 2.0) {
            result = 2.0;
        }
        return result;
    }

    public double getPictureOptimalSize() {
        if (this.Component == null || this.Component.width == 0 || this.Component.height == 0) {
            log.warn("Could not get window optimal size");
            return this.Default;
        }
        int PictureWidth = this.imageCanvas.getImageWidth();
        int PictureHeight = this.imageCanvas.getImageHeight();
        if (this.imageCanvas.getDegrees() / 90 % 2 == 1) {
            int temp = PictureHeight;
            PictureHeight = PictureWidth;
            PictureWidth = temp;
        }
        if (PictureHeight == 0 && PictureWidth == 0) {
            return this.Default;
        }
        double WindowsWidth = this.Component.getWidth();
        double WindowsHeight = this.Component.getHeight();
        return Math.min(WindowsWidth * 100.0 / (double)PictureWidth, WindowsHeight * 100.0 / (double)PictureHeight);
    }

    public void restoreTheDefaultPercent() {
        this.percent = this.Default;
    }

    public boolean isTheBiggestRatio() {
        return this.getPercent() >= 1500.0;
    }

    public boolean isTheSmallestRatio() {
        return this.getPercent() <= 2.0;
    }

    public synchronized double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        this.percent = percent > 1500.0 ? 1500.0 : (percent < 2.0 ? 2.0 : percent);
    }

    public boolean adjustPercent(int operate) {
        if (operate == 0 && this.percent == 1500.0 || operate == 1 && this.percent == 2.0) {
            return false;
        }
        double result = 0.0;
        switch (operate) {
            case 0: {
                if (this.AdjustPercent <= 0) {
                    result = this.percent < this.FittestPercent ? this.decide(4.0 + this.percent) : this.decide(11.0 + this.percent);
                } else if (this.percent < this.FittestPercent) {
                    result = this.decide((double)this.AdjustPercent + this.percent);
                } else if (this.percent > this.FittestPercent) {
                    result = this.decide((double)(2 * this.AdjustPercent) + this.percent);
                }
                this.percent = result;
                if (!(this.percent > 1500.0)) break;
                this.percent = 1500.0;
                break;
            }
            case 1: {
                if (this.AdjustPercent <= 0) {
                    result = this.percent < this.FittestPercent ? this.decide(-4.0 + this.percent) : this.decide(-11.0 + this.percent);
                } else if (this.percent < this.FittestPercent) {
                    result = this.decide((double)(-this.AdjustPercent) + this.percent);
                } else if (this.percent > this.FittestPercent) {
                    result = this.decide((double)(-2 * this.AdjustPercent) + this.percent);
                }
                this.percent = result;
                if (!(this.percent < 2.0)) break;
                this.percent = 1500.0;
            }
        }
        return true;
    }

    public void update(boolean isMove) {
        this.imageCanvas.setWindowSize(this.Component);
        this.imageCanvas.setIsMove(isMove || this.imageCanvas.getIsMove());
        this.imageCanvas.repaint();
    }

    public void close() {
        this.percent = 0.0;
        this.Component = null;
        this.imageCanvas.close();
    }
}

