/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.UIManager;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class FontPreservingUIUpdater {
    public static void updateComponentTreeUIWithFontPreservation(Component comp) {
        HashMap<Component, Font> fontMap = new HashMap<Component, Font>();
        FontPreservingUIUpdater.collectFonts(comp, fontMap);
        SwingUtilities.updateComponentTreeUI(comp);
        FontPreservingUIUpdater.restoreFonts(comp, fontMap);
    }

    private static void collectFonts(Component comp, Map<Component, Font> fontMap) {
        fontMap.put(comp, comp.getFont());
        if (comp instanceof Container) {
            for (Component child : ((Container)comp).getComponents()) {
                FontPreservingUIUpdater.collectFonts(child, fontMap);
            }
        }
    }

    private static void restoreFonts(Component comp, Map<Component, Font> fontMap) {
        Font originalFont = fontMap.get(comp);
        if (originalFont != null) {
            comp.setFont(originalFont);
        }
        if (comp instanceof Container) {
            for (Component child : ((Container)comp).getComponents()) {
                FontPreservingUIUpdater.restoreFonts(child, fontMap);
            }
        }
    }
}

