/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.UIManager;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public class SystemThemeMonitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemThemeMonitor.class);
    private final Consumer<Boolean> themeChangeCallback;
    private final OSThemeDetector detector;
    private final ScheduledExecutorService executor;
    private Boolean currentTheme;

    public SystemThemeMonitor(Consumer<Boolean> callback) {
        this.themeChangeCallback = callback;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.detector = Platform.isWindows() ? new WindowsThemeDetector() : (Platform.isLinux() ? new LinuxThemeDetector() : () -> false);
        this.executor.scheduleAtFixedRate(this::checkTheme, 0L, 1L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    public void startListener() {
        if (this.executor.isShutdown()) {
            this.executor.scheduleAtFixedRate(this::checkTheme, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    private void checkTheme() {
        try {
            Boolean newTheme = this.detector.isDarkMode();
            if (newTheme != null && !newTheme.equals(this.currentTheme)) {
                this.currentTheme = newTheme;
                this.themeChangeCallback.accept(newTheme);
            }
        }
        catch (Exception e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
    }

    public static class WindowsThemeDetector
    implements OSThemeDetector {
        private static final String PERSONALIZE_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
        private static final String APPS_USE_LIGHT_THEME = "AppsUseLightTheme";
        private static final String SYSTEM_USE_LIGHT_THEME = "SystemUsesLightTheme";

        private boolean detectCurrentTheme() {
            try {
                if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PERSONALIZE_KEY) && Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PERSONALIZE_KEY, (String)APPS_USE_LIGHT_THEME)) {
                    int value = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PERSONALIZE_KEY, (String)APPS_USE_LIGHT_THEME);
                    return value == 0;
                }
                if (Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PERSONALIZE_KEY, (String)SYSTEM_USE_LIGHT_THEME)) {
                    int value = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PERSONALIZE_KEY, (String)SYSTEM_USE_LIGHT_THEME);
                    return value == 0;
                }
                return false;
            }
            catch (Exception e) {
                log.error("Topic detection failed: {}", (Object)e.getMessage());
                return false;
            }
        }

        @Override
        public Boolean isDarkMode() {
            return this.detectCurrentTheme();
        }
    }

    private static interface OSThemeDetector {
        public Boolean isDarkMode() throws Exception;
    }

    private static class LinuxThemeDetector
    implements OSThemeDetector {
        private LinuxThemeDetector() {
        }

        @Override
        public Boolean isDarkMode() throws IOException {
            if (this.isGnome()) {
                Process process = Runtime.getRuntime().exec(new String[]{"gsettings", "get", "org.gnome.desktop.interface color-scheme"});
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line = reader.readLine();
                    Boolean bl = line != null && line.contains("dark");
                    return bl;
                }
            }
            return false;
        }

        private boolean isGnome() {
            boolean bl;
            Process process = Runtime.getRuntime().exec(new String[]{"echo", "$XDG_CURRENT_DESKTOP"});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                String line = reader.readLine();
                bl = line != null && line.contains("GNOME");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            reader.close();
            return bl;
        }
    }
}

