/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.UIManager;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Window;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.PicturePlayer.UIManager.DefaultUI;
import top.nserly.PicturePlayer.UIManager.FontPreservingUIUpdater;
import top.nserly.PicturePlayer.UIManager.LinuxUI;
import top.nserly.PicturePlayer.UIManager.SystemThemeMonitor;
import top.nserly.PicturePlayer.UIManager.WindowsUI;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public abstract class UIManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UIManager.class);
    public static final int FollowSystemTheme = 0;
    public static final int DarkTheme = 1;
    public static final int LightTheme = 2;
    private static final UIManager UIManager = top.nserly.PicturePlayer.UIManager.UIManager.createInstance();
    private int Theme = 0;

    protected UIManager() {
        System.setProperty("flatlaf.useSystemEnvironment", "true");
        SystemThemeMonitor monitor = new SystemThemeMonitor(isDark -> {
            int appliedTheme;
            int theme = isDark != false ? 1 : 2;
            if (theme == (appliedTheme = this.getAppliedTheme())) {
                return;
            }
            this.setupThemeListener(theme);
        });
    }

    private static UIManager createInstance() {
        if (SystemInfo.isWindows) {
            return new WindowsUI();
        }
        if (SystemInfo.isLinux) {
            return new LinuxUI();
        }
        log.warn("For unsupported operating systems, the default GUI theme will be used");
        return new DefaultUI();
    }

    public static synchronized void updateAllWindows() {
        SwingUtilities.invokeLater(() -> {
            for (Window window : Window.getWindows()) {
                if (window.isShowing()) {
                    window.dispose();
                    FontPreservingUIUpdater.updateComponentTreeUIWithFontPreservation(window);
                    window.setVisible(true);
                    continue;
                }
                FontPreservingUIUpdater.updateComponentTreeUIWithFontPreservation(window);
            }
        });
    }

    public static synchronized void updateChoiceWindows(List<Window> windowsCollections) {
        SwingUtilities.invokeLater(() -> {
            for (Window window : windowsCollections) {
                if (window.isShowing()) {
                    window.dispose();
                    FontPreservingUIUpdater.updateComponentTreeUIWithFontPreservation(window);
                    window.setVisible(true);
                    continue;
                }
                FontPreservingUIUpdater.updateComponentTreeUIWithFontPreservation(window);
            }
        });
    }

    public synchronized int getAppliedTheme() {
        LookAndFeel laf = javax.swing.UIManager.getLookAndFeel();
        if (laf instanceof FlatLaf) {
            return ((FlatLaf)laf).isDark() ? 1 : 2;
        }
        return 0;
    }

    public synchronized void applyThemeOnSystem() {
        int SystemTheme = this.getSystemTheme();
        if (this.getAppliedTheme() == SystemTheme) {
            return;
        }
        if (this.Theme != 0) {
            this.Theme = SystemTheme;
        }
        this.applyTheme(SystemTheme);
    }

    public synchronized void applyThemeAndRefreshWindows() {
        int SystemTheme = this.getSystemTheme();
        if (this.getAppliedTheme() == SystemTheme) {
            return;
        }
        if (this.Theme != 0) {
            this.Theme = SystemTheme;
        }
        this.applyTheme(SystemTheme);
        top.nserly.PicturePlayer.UIManager.UIManager.updateAllWindows();
    }

    public synchronized void applyTheme(int theme) {
        try {
            switch (theme) {
                case 1: {
                    javax.swing.UIManager.setLookAndFeel((LookAndFeel)new FlatDarkLaf());
                    break;
                }
                case 2: {
                    javax.swing.UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
                    break;
                }
                default: {
                    throw new RuntimeException("The theme is set up incorrectly!");
                }
            }
        }
        catch (Exception e) {
            try {
                javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception ex) {
                log.error(ExceptionHandler.getExceptionMessage(e));
            }
        }
    }

    public synchronized void applyThemeAndRefreshWindows(int theme) {
        if (theme == this.getAppliedTheme()) {
            return;
        }
        this.applyTheme(theme);
        top.nserly.PicturePlayer.UIManager.UIManager.updateAllWindows();
    }

    public synchronized void applyThemeOnSet() {
        if (this.Theme == 0) {
            this.applyTheme(this.getSystemTheme());
        } else {
            this.applyTheme(this.Theme);
        }
    }

    public synchronized void applyThemeOnSetAndRefreshWindows() {
        if (this.Theme == 0) {
            this.applyThemeAndRefreshWindows(this.getSystemTheme());
        } else {
            this.applyThemeAndRefreshWindows(this.Theme);
        }
    }

    public abstract int getSystemTheme();

    public abstract void setupThemeListener(int var1);

    @Generated
    public void setTheme(int Theme) {
        this.Theme = Theme;
    }

    @Generated
    public static UIManager getUIManager() {
        return UIManager;
    }

    @Generated
    public int getTheme() {
        return this.Theme;
    }
}

