/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.UIManager;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.PicturePlayer.UIManager.UIManager;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public class WindowsUI
extends UIManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsUI.class);

    protected WindowsUI() {
        System.setProperty("flatlaf.win.enableSystemThemeChangeListener", "true");
    }

    @Override
    public int getSystemTheme() {
        try {
            String keyPath = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
            String valueName = "AppsUseLightTheme";
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize")) {
                int value = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", (String)"AppsUseLightTheme");
                return ++value;
            }
        }
        catch (Exception e) {
            log.error("Registry read failed");
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
        return 2;
    }

    @Override
    public void setupThemeListener(int theme) {
        if (this.getTheme() == 0) {
            this.applyThemeAndRefreshWindows(theme);
        }
    }
}

