/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ImageManager.Blur.Implements;

import java.awt.image.BufferedImage;

public class BlurKernelSizeCompute {
    public static int calculateKernelSize(BufferedImage bufferedImage, double scaleFactor) {
        boolean isHighResWithSmallChange;
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Images cannot be null");
        }
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("The scaling factor must be positive");
        }
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        boolean isNearlyOriginalScale = Math.abs((scaleFactor /= 100.0) - 1.0) <= 0.08;
        boolean isTinyImage = width < 50 || height < 50;
        boolean bl = isHighResWithSmallChange = width > 1000 && height > 1000 && Math.abs(scaleFactor - 1.0) <= 0.15;
        if (isNearlyOriginalScale || isTinyImage || isHighResWithSmallChange || scaleFactor - 1.0 >= 0.1) {
            return 1;
        }
        return BlurKernelSizeCompute.getBaseKernel(scaleFactor);
    }

    private static int getBaseKernel(double scaleFactor) {
        double scaleDiff = Math.abs(scaleFactor - 1.0);
        int baseKernel = scaleFactor < 1.0 ? (int)Math.round(scaleDiff * 12.0) : (int)Math.round(scaleDiff * 8.0);
        baseKernel = Math.max(3, baseKernel);
        if ((baseKernel = Math.min(21, baseKernel)) % 2 == 0) {
            ++baseKernel;
        }
        return baseKernel;
    }
}

