/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ImageManager.Blur.Implements;

import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.jocl.CL;
import org.jocl.CLException;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_context_properties;
import org.jocl.cl_device_id;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;
import org.jocl.cl_platform_id;
import org.jocl.cl_program;
import org.jocl.cl_queue_properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.PicturePlayer.Utils.ImageManager.Blur.Implements.BlurProcessorHandleAction;
import top.nserly.PicturePlayer.Utils.ImageManager.Blur.Implements.OpenCLSupportChecker;
import top.nserly.SoftwareCollections_API.FileHandle.FileContents;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public class OpenCLBlurProcessor
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenCLBlurProcessor.class);
    private static boolean isSupportedOpenCL;
    private static String SelectedDevice;
    private static int DeviceCount;
    private static final ReentrantLock staticLock;
    private static final ReentrantLock DeviceSelectorLock;
    private static final Thread GetIsSupportedOpenCL;
    private static final AtomicBoolean staticInitialized;
    private static final AtomicInteger instanceCount;
    private static final AtomicBoolean staticInitializing;
    private static int SelectDeviceIndex;
    private static final CountDownLatch initLatch;
    private final AtomicBoolean instanceClosed = new AtomicBoolean(false);
    private static final String KERNEL_SOURCE;
    private static cl_context clContext;
    private static cl_command_queue clCommandQueue;
    private static cl_program clProgram;
    private static cl_kernel blurKernel;
    private static final List<cl_device_id> allDevices;
    private cl_mem inputBuffer = null;
    private cl_mem outputBuffer = null;
    private int currentWidth = 0;
    private int currentHeight = 0;
    private int pixelCount = 0;
    private final AtomicBoolean isProcessing = new AtomicBoolean(false);
    private final ReentrantLock instanceLock = new ReentrantLock();
    private BlurProcessorHandleAction handleAction;

    public static boolean getIsSupportedOpenCL() {
        try {
            GetIsSupportedOpenCL.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return isSupportedOpenCL;
    }

    public static int getDeviceCount() {
        try {
            GetIsSupportedOpenCL.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return DeviceCount;
    }

    public static synchronized boolean setSelectDeviceIndex(int index) {
        DeviceSelectorLock.lock();
        try {
            index = Math.max(0, Math.min(index, OpenCLBlurProcessor.getDeviceCount() - 1));
            if (index == SelectDeviceIndex) {
                boolean bl = true;
                return bl;
            }
            SelectDeviceIndex = index;
            OpenCLBlurProcessor.closeBlurProcessor();
            OpenCLBlurProcessor.init();
        }
        finally {
            DeviceSelectorLock.unlock();
        }
        return SelectedDevice != null && !SelectedDevice.isEmpty();
    }

    public static int getSelectDeviceIndex() {
        DeviceSelectorLock.lock();
        try {
            int n = SelectDeviceIndex;
            return n;
        }
        finally {
            DeviceSelectorLock.unlock();
        }
    }

    public static String getSelectedDevice() {
        staticLock.lock();
        try {
            if (!staticInitialized.get()) {
                initLatch.await();
            }
            String string = SelectedDevice;
            return string;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for OpenCL initialization", e);
        }
        finally {
            staticLock.unlock();
        }
    }

    public OpenCLBlurProcessor() {
        instanceCount.incrementAndGet();
        log.debug("OpenCLBlurProcessor instance created. Total instances: {}", (Object)instanceCount.get());
    }

    public OpenCLBlurProcessor(BufferedImage bufferedImage) {
        this();
        this.changeImage(bufferedImage);
    }

    public static void init() {
        if (staticInitialized.get()) {
            log.info("OpenCL is already initialized");
            return;
        }
        try {
            GetIsSupportedOpenCL.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!isSupportedOpenCL) {
            log.error("OpenCL is not supported on this system");
            return;
        }
        if (!staticInitializing.compareAndSet(false, true)) {
            log.info("OpenCL initialization is already in progress, waiting...");
            try {
                initLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for OpenCL initialization", e);
            }
            return;
        }
        staticLock.lock();
        try {
            if (staticInitialized.get()) {
                return;
            }
            log.info("Initializing OpenCL static resources...");
            CL.setExceptionsEnabled((boolean)true);
            allDevices.clear();
            int[] numPlatforms = new int[1];
            CL.clGetPlatformIDs((int)0, null, (int[])numPlatforms);
            if (numPlatforms[0] == 0) {
                throw new RuntimeException("No OpenCL platforms found");
            }
            cl_platform_id[] platforms = new cl_platform_id[numPlatforms[0]];
            CL.clGetPlatformIDs((int)platforms.length, (cl_platform_id[])platforms, null);
            for (cl_platform_id platform : platforms) {
                long devicePtr;
                int i;
                long platformPtr = OpenCLBlurProcessor.getPlatformPointer(platform);
                log.info("Processing OpenCL platform [Pointer: 0x{}]", (Object)Long.toHexString(platformPtr));
                try {
                    log.debug("Attempting to detect GPU devices for platform [Pointer: 0x{}]", (Object)Long.toHexString(platformPtr));
                    int[] numGpuDevices = new int[1];
                    CL.clGetDeviceIDs((cl_platform_id)platform, (long)4L, (int)0, null, (int[])numGpuDevices);
                    log.debug("GPU device count detected for platform [Pointer: 0x{}]: {}", (Object)Long.toHexString(platformPtr), (Object)numGpuDevices[0]);
                    if (numGpuDevices[0] > 0) {
                        cl_device_id[] gpuDevices = new cl_device_id[numGpuDevices[0]];
                        CL.clGetDeviceIDs((cl_platform_id)platform, (long)4L, (int)gpuDevices.length, (cl_device_id[])gpuDevices, null);
                        log.info("Successfully collected {} GPU device(s) for platform [Pointer: 0x{}]", (Object)gpuDevices.length, (Object)Long.toHexString(platformPtr));
                        for (i = 0; i < gpuDevices.length; ++i) {
                            devicePtr = OpenCLBlurProcessor.getDevicePointer(gpuDevices[i]);
                            log.debug("GPU Device {} for platform [Pointer: 0x{}] - Device Pointer: 0x{}", new Object[]{i + 1, Long.toHexString(platformPtr), Long.toHexString(devicePtr)});
                        }
                        Collections.addAll(allDevices, gpuDevices);
                        log.debug("Added {} GPU device(s) to allDevices collection", (Object)gpuDevices.length);
                        continue;
                    }
                    log.debug("No GPU devices found for platform [Pointer: 0x{}]", (Object)Long.toHexString(platformPtr));
                }
                catch (Exception e) {
                    log.warn("Failed to detect GPU devices for platform [Pointer: 0x{}]. Falling back to CPU detection.", (Object)Long.toHexString(platformPtr), (Object)e);
                }
                log.debug("Falling back to CPU device detection for platform [Pointer: 0x{}]", (Object)Long.toHexString(platformPtr));
                int[] numCpuDevices = new int[1];
                CL.clGetDeviceIDs((cl_platform_id)platform, (long)2L, (int)0, null, (int[])numCpuDevices);
                log.debug("CPU device count detected for platform [Pointer: 0x{}]: {}", (Object)Long.toHexString(platformPtr), (Object)numCpuDevices[0]);
                if (numCpuDevices[0] > 0) {
                    cl_device_id[] cpuDevices = new cl_device_id[numCpuDevices[0]];
                    CL.clGetDeviceIDs((cl_platform_id)platform, (long)2L, (int)cpuDevices.length, (cl_device_id[])cpuDevices, null);
                    log.info("Successfully collected {} CPU device(s) for platform [Pointer: 0x{}]", (Object)cpuDevices.length, (Object)Long.toHexString(platformPtr));
                    for (i = 0; i < cpuDevices.length; ++i) {
                        devicePtr = OpenCLBlurProcessor.getDevicePointer(cpuDevices[i]);
                        log.debug("CPU Device {} for platform [Pointer: 0x{}] - Device Pointer: 0x{}", new Object[]{i + 1, Long.toHexString(platformPtr), Long.toHexString(devicePtr)});
                    }
                    Collections.addAll(allDevices, cpuDevices);
                    log.debug("Added {} CPU device(s) to allDevices collection", (Object)cpuDevices.length);
                    continue;
                }
                log.warn("No CPU devices found for platform [Pointer: 0x{}]. No devices will be added from this platform.", (Object)Long.toHexString(platformPtr));
            }
            log.info("OpenCL device detection completed. Total devices collected: {}", (Object)allDevices.size());
            if (!allDevices.isEmpty()) {
                log.debug("Complete list of collected OpenCL devices:");
                for (int i = 0; i < allDevices.size(); ++i) {
                    long devicePtr = OpenCLBlurProcessor.getDevicePointer(allDevices.get(i));
                    log.debug("Device {} - Pointer: 0x{}", (Object)(i + 1), (Object)Long.toHexString(devicePtr));
                }
            } else {
                log.error("No OpenCL devices (GPU/CPU) were found across all platforms!");
            }
            if (allDevices.isEmpty()) {
                throw new RuntimeException("No OpenCL devices found across all platforms");
            }
            DeviceCount = allDevices.size();
            SelectDeviceIndex = Math.max(0, Math.min(SelectDeviceIndex, allDevices.size() - 1));
            cl_device_id selectedDevice = allDevices.get(SelectDeviceIndex);
            cl_platform_id selectedPlatform = OpenCLBlurProcessor.getPlatformFromDevice(selectedDevice);
            cl_context_properties contextProperties = new cl_context_properties();
            contextProperties.addProperty(4228L, selectedPlatform);
            clContext = CL.clCreateContext((cl_context_properties)contextProperties, (int)1, (cl_device_id[])new cl_device_id[]{selectedDevice}, null, null, null);
            clCommandQueue = CL.clCreateCommandQueueWithProperties((cl_context)clContext, (cl_device_id)selectedDevice, (cl_queue_properties)new cl_queue_properties(), null);
            clProgram = CL.clCreateProgramWithSource((cl_context)clContext, (int)1, (String[])new String[]{KERNEL_SOURCE}, null, null);
            try {
                CL.clBuildProgram((cl_program)clProgram, (int)1, (cl_device_id[])new cl_device_id[]{selectedDevice}, null, null, null);
            }
            catch (CLException e) {
                byte[] buildLog = new byte[8192];
                CL.clGetProgramBuildInfo((cl_program)clProgram, (cl_device_id)selectedDevice, (int)4483, (long)buildLog.length, (Pointer)Pointer.to((byte[])buildLog), null);
                String logMsg = new String(buildLog).trim();
                log.error("OpenCL build error: {}", (Object)logMsg);
                throw new RuntimeException("OpenCL build failed: " + logMsg, e);
            }
            blurKernel = CL.clCreateKernel((cl_program)clProgram, (String)"gaussianBlur", null);
            staticInitialized.set(true);
            SelectedDevice = OpenCLBlurProcessor.getDeviceName(selectedDevice);
            log.info("OpenCL static resources initialized successfully with device: {}", (Object)SelectedDevice);
        }
        catch (Exception e) {
            staticInitializing.set(false);
            log.error("OpenCL initialization failed: {}", (Object)e.getMessage());
            log.error(ExceptionHandler.getExceptionMessage(e));
            OpenCLBlurProcessor.releaseStaticResources();
            throw new RuntimeException("OpenCL initialization failed", e);
        }
        finally {
            staticInitializing.set(false);
            staticLock.unlock();
            initLatch.countDown();
        }
    }

    private static long getPlatformPointer(cl_platform_id platform) {
        return platform != null ? (long)platform.hashCode() : 0L;
    }

    private static long getDevicePointer(cl_device_id device) {
        return device != null ? (long)device.hashCode() : 0L;
    }

    private static cl_platform_id getPlatformFromDevice(cl_device_id device) {
        cl_platform_id[] platform = new cl_platform_id[1];
        CL.clGetDeviceInfo((cl_device_id)device, (int)4145, (long)Sizeof.cl_platform_id, (Pointer)Pointer.to((NativePointerObject[])platform), null);
        return platform[0];
    }

    public static void closeBlurProcessor() {
        staticLock.lock();
        try {
            if (!staticInitialized.get()) {
                log.info("OpenCL is not initialized, nothing to close");
                return;
            }
            log.info("Closing OpenCL static resources...");
            OpenCLBlurProcessor.releaseStaticResources();
            staticInitialized.set(false);
            log.info("OpenCL static resources closed successfully");
        }
        finally {
            staticLock.unlock();
        }
    }

    private static void releaseStaticResources() {
        SelectedDevice = null;
        allDevices.clear();
        if (blurKernel != null) {
            try {
                CL.clReleaseKernel((cl_kernel)blurKernel);
            }
            catch (Exception e) {
                log.warn("Error releasing kernel: {}", (Object)e.getMessage());
            }
            blurKernel = null;
        }
        if (clProgram != null) {
            try {
                CL.clReleaseProgram((cl_program)clProgram);
            }
            catch (Exception e) {
                log.warn("Error releasing program: {}", (Object)e.getMessage());
            }
            clProgram = null;
        }
        if (clCommandQueue != null) {
            try {
                CL.clReleaseCommandQueue((cl_command_queue)clCommandQueue);
            }
            catch (Exception e) {
                log.warn("Error releasing command queue: {}", (Object)e.getMessage());
            }
            clCommandQueue = null;
        }
        if (clContext != null) {
            try {
                CL.clReleaseContext((cl_context)clContext);
            }
            catch (Exception e) {
                log.warn("Error releasing context: {}", (Object)e.getMessage());
            }
            clContext = null;
        }
    }

    private static String getDeviceName(cl_device_id device) {
        try {
            byte[] nameBytes = new byte[1024];
            CL.clGetDeviceInfo((cl_device_id)device, (int)4139, (long)nameBytes.length, (Pointer)Pointer.to((byte[])nameBytes), null);
            return new String(nameBytes).trim();
        }
        catch (Exception e) {
            log.warn("Failed to get device name: {}", (Object)e.getMessage());
            return "Unknown Device";
        }
    }

    public static boolean isOpenCLAvailable() {
        return staticInitialized.get();
    }

    public void changeImage(BufferedImage image) {
        this.instanceLock.lock();
        try {
            if (this.instanceClosed.get()) {
                log.warn("Attempted to change image on a closed processor");
                return;
            }
            this.releaseInstanceResources();
            if (image != null) {
                this.updateImageBuffer(image);
            }
            log.debug("Image changed successfully");
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage applyBlur(int kernelSize) {
        this.instanceLock.lock();
        try {
            BufferedImage image;
            if (this.instanceClosed.get() || !staticInitialized.get()) {
                log.info("Processor is closed or OpenCL not initialized, attempting to reinitialize...");
                try {
                    OpenCLBlurProcessor.init();
                    this.instanceClosed.set(false);
                }
                catch (Exception e) {
                    log.error("Failed to reinitialize OpenCL: {}", (Object)e.getMessage());
                    BufferedImage bufferedImage = null;
                    this.instanceLock.unlock();
                    this.isProcessing.set(false);
                    return bufferedImage;
                }
            }
            if (!this.hasValidImageData()) {
                log.debug("No valid image data, trying to get from handle action");
                if (this.handleAction == null) {
                    log.error("BlurProcessorHandleAction is not set");
                    BufferedImage e = null;
                    return e;
                }
                image = this.handleAction.getSrcBlurBufferedImage();
                if (image == null) {
                    log.error("Failed to get image from handle action");
                    BufferedImage bufferedImage = null;
                    return bufferedImage;
                }
                this.changeImage(image);
            }
            if (kernelSize < 1 || kernelSize % 2 == 0) {
                throw new IllegalArgumentException("Kernel size must be positive and odd");
            }
            if (!this.isProcessing.compareAndSet(false, true)) {
                log.warn("OpenCL processing already in progress");
                image = null;
                return image;
            }
            float sigma = Math.max(1.0f, (float)kernelSize / 3.0f);
            CL.clSetKernelArg((cl_kernel)blurKernel, (int)0, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)this.inputBuffer));
            CL.clSetKernelArg((cl_kernel)blurKernel, (int)1, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)this.outputBuffer));
            CL.clSetKernelArg((cl_kernel)blurKernel, (int)2, (long)4L, (Pointer)Pointer.to((int[])new int[]{this.currentWidth}));
            CL.clSetKernelArg((cl_kernel)blurKernel, (int)3, (long)4L, (Pointer)Pointer.to((int[])new int[]{this.currentHeight}));
            CL.clSetKernelArg((cl_kernel)blurKernel, (int)4, (long)4L, (Pointer)Pointer.to((int[])new int[]{kernelSize}));
            CL.clSetKernelArg((cl_kernel)blurKernel, (int)5, (long)4L, (Pointer)Pointer.to((float[])new float[]{sigma}));
            long[] globalWorkSize = new long[]{this.currentWidth, this.currentHeight};
            CL.clEnqueueNDRangeKernel((cl_command_queue)clCommandQueue, (cl_kernel)blurKernel, (int)2, null, (long[])globalWorkSize, null, (int)0, null, null);
            CL.clFinish((cl_command_queue)clCommandQueue);
            int[] resultPixels = new int[this.pixelCount];
            IntBuffer resultBuffer = IntBuffer.wrap(resultPixels);
            CL.clEnqueueReadBuffer((cl_command_queue)clCommandQueue, (cl_mem)this.outputBuffer, (boolean)true, (long)0L, (long)((long)this.pixelCount * 4L), (Pointer)Pointer.to((Buffer)resultBuffer), (int)0, null, null);
            BufferedImage result = new BufferedImage(this.currentWidth, this.currentHeight, 2);
            result.setRGB(0, 0, this.currentWidth, this.currentHeight, resultPixels, 0, this.currentWidth);
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        catch (CLException e) {
            log.error("OpenCL processing failed with error code: {}", (Object)e.getStatus());
            log.error(ExceptionHandler.getExceptionMessage(e));
            this.instanceClosed.set(true);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        catch (Exception e) {
            log.error("Unexpected error during OpenCL processing: {}", (Object)e.getMessage());
            log.error(ExceptionHandler.getExceptionMessage(e));
            this.instanceClosed.set(true);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            this.instanceLock.unlock();
            this.isProcessing.set(false);
        }
    }

    private boolean hasValidImageData() {
        return this.currentWidth > 0 && this.currentHeight > 0 && this.pixelCount == this.currentWidth * this.currentHeight && this.inputBuffer != null && this.outputBuffer != null;
    }

    private void updateImageBuffer(BufferedImage image) {
        this.releaseInstanceResources();
        this.currentWidth = image.getWidth();
        this.currentHeight = image.getHeight();
        this.pixelCount = this.currentWidth * this.currentHeight;
        this.inputBuffer = CL.clCreateBuffer((cl_context)clContext, (long)4L, (long)((long)this.pixelCount * 4L), null, null);
        this.outputBuffer = CL.clCreateBuffer((cl_context)clContext, (long)2L, (long)((long)this.pixelCount * 4L), null, null);
        this.updateInputBufferData(image);
        log.debug("Image buffer updated for size: {}x{}", (Object)this.currentWidth, (Object)this.currentHeight);
    }

    private void updateInputBufferData(BufferedImage image) {
        if (this.inputBuffer == null || this.pixelCount == 0 || image == null) {
            return;
        }
        int[] pixels = image.getRGB(0, 0, this.currentWidth, this.currentHeight, null, 0, this.currentWidth);
        IntBuffer pixelBuffer = IntBuffer.wrap(pixels);
        CL.clEnqueueWriteBuffer((cl_command_queue)clCommandQueue, (cl_mem)this.inputBuffer, (boolean)true, (long)0L, (long)((long)this.pixelCount * 4L), (Pointer)Pointer.to((Buffer)pixelBuffer), (int)0, null, null);
    }

    private void releaseInstanceResources() {
        if (this.outputBuffer != null) {
            try {
                CL.clReleaseMemObject((cl_mem)this.outputBuffer);
            }
            catch (Exception e) {
                log.warn("Error releasing output buffer: {}", (Object)e.getMessage());
            }
            this.outputBuffer = null;
        }
        if (this.inputBuffer != null) {
            try {
                CL.clReleaseMemObject((cl_mem)this.inputBuffer);
            }
            catch (Exception e) {
                log.warn("Error releasing input buffer: {}", (Object)e.getMessage());
            }
            this.inputBuffer = null;
        }
        this.currentWidth = 0;
        this.currentHeight = 0;
        this.pixelCount = 0;
    }

    @Override
    public void close() {
        this.instanceLock.lock();
        try {
            if (this.instanceClosed.get()) {
                return;
            }
            this.releaseInstanceResources();
            this.instanceClosed.set(true);
            int count = instanceCount.decrementAndGet();
            log.debug("OpenCLBlurProcessor instance closed. Remaining instances: {}", (Object)count);
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    public String getName() {
        return "OpenCL_Accelerated_Blur_Processor";
    }

    public boolean isAvailable() {
        return !this.instanceClosed.get() && staticInitialized.get() && this.inputBuffer != null && this.outputBuffer != null;
    }

    @Generated
    public void setHandleAction(BlurProcessorHandleAction handleAction) {
        this.handleAction = handleAction;
    }

    static {
        staticLock = new ReentrantLock();
        DeviceSelectorLock = new ReentrantLock();
        GetIsSupportedOpenCL = new Thread(() -> {
            isSupportedOpenCL = OpenCLSupportChecker.isOpenCLSupported();
            DeviceCount = OpenCLSupportChecker.getSupported_GPU_Device() > 0 ? OpenCLSupportChecker.getSupported_GPU_Device() : OpenCLSupportChecker.getSupported_CPU_Device();
        });
        staticInitialized = new AtomicBoolean(false);
        instanceCount = new AtomicInteger(0);
        staticInitializing = new AtomicBoolean(false);
        initLatch = new CountDownLatch(1);
        KERNEL_SOURCE = FileContents.read(OpenCLBlurProcessor.class.getResource("AdvancedImageBlur.c"));
        clContext = null;
        clCommandQueue = null;
        clProgram = null;
        blurKernel = null;
        allDevices = new ArrayList<cl_device_id>();
        GetIsSupportedOpenCL.start();
    }
}

