/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ImageManager.Blur.Implements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.jocl.CL;
import org.jocl.CLException;
import org.jocl.Pointer;
import org.jocl.cl_device_id;
import org.jocl.cl_platform_id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenCLSupportChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenCLSupportChecker.class);
    private static final int BUFFER_SIZE = 1024;
    private static final byte[] buffer = new byte[1024];
    private static final ArrayList<String> Supported_GPU_Device_Name_List = new ArrayList();
    private static final ArrayList<String> Supported_CPU_Device_Name_List = new ArrayList();
    private static int Supported_GPU_Device = 0;
    private static int Supported_CPU_Device = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOpenCLSupported() {
        Supported_GPU_Device_Name_List.clear();
        Supported_CPU_Device_Name_List.clear();
        Supported_GPU_Device = 0;
        Supported_CPU_Device = 0;
        try {
            CL.setExceptionsEnabled((boolean)true);
            int[] numPlatforms = new int[1];
            CL.clGetPlatformIDs((int)0, null, (int[])numPlatforms);
            if (numPlatforms[0] == 0) {
                log.info("No OpenCL platforms found");
                boolean bl = false;
                return bl;
            }
            cl_platform_id[] platforms = new cl_platform_id[numPlatforms[0]];
            CL.clGetPlatformIDs((int)platforms.length, (cl_platform_id[])platforms, null);
            boolean hasSupportedDevice = false;
            for (cl_platform_id platform : platforms) {
                boolean platformHasGPU = OpenCLSupportChecker.checkDeviceType(platform, 4L);
                boolean platformHasCPU = OpenCLSupportChecker.checkDeviceType(platform, 2L);
                if (!platformHasGPU && !platformHasCPU) continue;
                hasSupportedDevice = true;
            }
            if (!hasSupportedDevice) {
                log.info("No OpenCL devices (GPU/CPU) found on any platform");
            }
            boolean bl = hasSupportedDevice;
            return bl;
        }
        catch (Exception e) {
            log.error("OpenCL check failed: {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            CL.setExceptionsEnabled((boolean)false);
        }
    }

    public static List<String> getSupported_GPU_Device_Name_List() {
        return new ArrayList<String>(Supported_GPU_Device_Name_List);
    }

    public static List<String> getSupported_CPU_Device_Name_List() {
        return new ArrayList<String>(Supported_CPU_Device_Name_List);
    }

    public static List<String> getSupported_Device_Name() {
        if (!Supported_GPU_Device_Name_List.isEmpty()) {
            return OpenCLSupportChecker.getSupported_GPU_Device_Name_List();
        }
        return OpenCLSupportChecker.getSupported_CPU_Device_Name_List();
    }

    private static boolean checkDeviceType(cl_platform_id platform, long deviceType) {
        try {
            int[] numDevices = new int[1];
            CL.clGetDeviceIDs((cl_platform_id)platform, (long)deviceType, (int)0, null, (int[])numDevices);
            if (numDevices[0] <= 0) {
                return false;
            }
            cl_device_id[] devices = new cl_device_id[numDevices[0]];
            CL.clGetDeviceIDs((cl_platform_id)platform, (long)deviceType, (int)devices.length, (cl_device_id[])devices, null);
            for (cl_device_id device : devices) {
                OpenCLSupportChecker.clearBuffer();
                CL.clGetDeviceInfo((cl_device_id)device, (int)4139, (long)1024L, (Pointer)Pointer.to((byte[])buffer), null);
                String deviceName = new String(buffer).trim();
                if (deviceType == 4L) {
                    Supported_GPU_Device_Name_List.add(deviceName);
                } else if (deviceType == 2L) {
                    Supported_CPU_Device_Name_List.add(deviceName);
                }
                log.debug("Found {} device: {}", (Object)(deviceType == 4L ? "GPU" : "CPU"), (Object)deviceName);
            }
            if (deviceType == 4L) {
                Supported_GPU_Device += numDevices[0];
            } else if (deviceType == 2L) {
                Supported_CPU_Device += numDevices[0];
            }
            log.info("Found {} {} devices on platform", (Object)numDevices[0], (Object)(deviceType == 4L ? "GPU" : "CPU"));
            return true;
        }
        catch (CLException e) {
            log.warn("Failed to check {} devices on platform (error code: {}): {}", new Object[]{deviceType == 4L ? "GPU" : "CPU", e.getStatus(), e.getMessage()});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOpenCLInfo() {
        StringBuilder info = new StringBuilder();
        try {
            CL.setExceptionsEnabled((boolean)true);
            int[] numPlatforms = new int[1];
            CL.clGetPlatformIDs((int)0, null, (int[])numPlatforms);
            if (numPlatforms[0] == 0) {
                String string = "No OpenCL platforms found";
                return string;
            }
            cl_platform_id[] platforms = new cl_platform_id[numPlatforms[0]];
            CL.clGetPlatformIDs((int)platforms.length, (cl_platform_id[])platforms, null);
            info.append("Found ").append(numPlatforms[0]).append(" OpenCL platform(s)\n");
            for (int i = 0; i < platforms.length; ++i) {
                info.append("\nPlatform ").append(i).append(":\n");
                OpenCLSupportChecker.appendPlatformInfo(info, platforms[i]);
                OpenCLSupportChecker.appendDeviceInfo(info, platforms[i], 4L, "GPU Devices");
                OpenCLSupportChecker.appendDeviceInfo(info, platforms[i], 2L, "CPU Devices");
            }
            String string = info.toString();
            return string;
        }
        catch (Exception e) {
            String string = "Error getting OpenCL info: " + e.getMessage();
            return string;
        }
        finally {
            CL.setExceptionsEnabled((boolean)false);
        }
    }

    private static void clearBuffer() {
        Arrays.fill(buffer, (byte)0);
    }

    private static void appendPlatformInfo(StringBuilder info, cl_platform_id platform) {
        OpenCLSupportChecker.clearBuffer();
        CL.clGetPlatformInfo((cl_platform_id)platform, (int)2306, (long)1024L, (Pointer)Pointer.to((byte[])buffer), null);
        info.append("  Name: ").append(new String(buffer).trim()).append("\n");
        OpenCLSupportChecker.clearBuffer();
        CL.clGetPlatformInfo((cl_platform_id)platform, (int)2307, (long)1024L, (Pointer)Pointer.to((byte[])buffer), null);
        info.append("  Vendor: ").append(new String(buffer).trim()).append("\n");
        OpenCLSupportChecker.clearBuffer();
        CL.clGetPlatformInfo((cl_platform_id)platform, (int)2305, (long)1024L, (Pointer)Pointer.to((byte[])buffer), null);
        info.append("  Version: ").append(new String(buffer).trim()).append("\n");
    }

    private static void appendDeviceInfo(StringBuilder info, cl_platform_id platform, long deviceType, String deviceTypeName) {
        int[] numDevices = new int[1];
        try {
            CL.clGetDeviceIDs((cl_platform_id)platform, (long)deviceType, (int)0, null, (int[])numDevices);
            if (numDevices[0] > 0) {
                cl_device_id[] devices = new cl_device_id[numDevices[0]];
                CL.clGetDeviceIDs((cl_platform_id)platform, (long)deviceType, (int)devices.length, (cl_device_id[])devices, null);
                info.append("  ").append(deviceTypeName).append(": ").append(numDevices[0]).append("\n");
                for (cl_device_id device : devices) {
                    OpenCLSupportChecker.clearBuffer();
                    CL.clGetDeviceInfo((cl_device_id)device, (int)4139, (long)1024L, (Pointer)Pointer.to((byte[])buffer), null);
                    info.append("    ").append(new String(buffer).trim()).append("\n");
                }
            }
        }
        catch (CLException e) {
            info.append("  ").append(deviceTypeName).append(": Error checking devices (code: ").append(e.getStatus()).append(")\n");
        }
    }

    @Generated
    public static int getSupported_GPU_Device() {
        return Supported_GPU_Device;
    }

    @Generated
    public static int getSupported_CPU_Device() {
        return Supported_CPU_Device;
    }
}

