/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ImageManager;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.GetImageInformation;

public class CheckFileIsRightPictureType {
    ArrayList<File> CheckFileList = new ArrayList();
    ArrayList<File> FinishedList = new ArrayList();
    ArrayList<File> UnfinishedList = new ArrayList();
    ArrayList<File> NotImageList = new ArrayList();
    ArrayList<File> ImageList = new ArrayList();

    public CheckFileIsRightPictureType(File ... files) {
        this.add(files);
    }

    public CheckFileIsRightPictureType(List<File> files) {
        this.add(files);
    }

    public void add(File ... files) {
        this.CheckFileList.addAll(Arrays.asList(files));
        this.UnfinishedList.addAll(Arrays.asList(files));
    }

    public void add(List<File> files) {
        this.CheckFileList.addAll(files);
        this.UnfinishedList.addAll(files);
    }

    public void statistics() {
        for (File file : this.UnfinishedList) {
            this.FinishedList.add(file);
            if (GetImageInformation.isImageFile(file)) {
                this.ImageList.add(file);
                continue;
            }
            this.NotImageList.add(file);
        }
        this.UnfinishedList.clear();
    }

    public int getImageCount() {
        return this.ImageList.size();
    }

    public int getNotImageCount() {
        return this.NotImageList.size();
    }

    public void clear() {
        this.NotImageList.clear();
        this.ImageList.clear();
        this.CheckFileList.clear();
        this.FinishedList.clear();
        this.UnfinishedList.clear();
    }

    public boolean isFinished() {
        return this.UnfinishedList.isEmpty();
    }

    public String filePathToString(String separator, File ... files) {
        StringBuilder sb = new StringBuilder();
        boolean isFist = true;
        for (File file : files) {
            if (!isFist) {
                sb.append(separator);
            }
            sb.append(file.getAbsolutePath());
            isFist = false;
        }
        return sb.toString();
    }

    public String filePathToString(String separator, ArrayList<File> files) {
        StringBuilder sb = new StringBuilder();
        boolean isFist = true;
        for (File file : files) {
            if (!isFist) {
                sb.append(separator);
            }
            sb.append(file.getAbsolutePath());
            isFist = false;
        }
        return sb.toString();
    }

    @Generated
    public ArrayList<File> getNotImageList() {
        return this.NotImageList;
    }

    @Generated
    public ArrayList<File> getImageList() {
        return this.ImageList;
    }
}

