/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ImageManager.Info;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.PicturePlayer.Size.GetSystemSize;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageHandle;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public class GetImageInformation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetImageInformation.class);
    public static final boolean isHardwareAccelerated;
    public static final String[] readFormats;
    private static final ArrayList<String> SupportPictureExtension;

    public static BufferedImage getImage(String path) throws NullPointerException {
        BufferedImage bufferedImage;
        block8: {
            ImageHandle imageHandle = GetImageInformation.getImageHandle(new File(path));
            try {
                bufferedImage = GetImageInformation.getImage(imageHandle.imageReader());
                if (imageHandle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (imageHandle != null) {
                        try {
                            imageHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error(ExceptionHandler.getExceptionMessage(e));
                    return null;
                }
            }
            imageHandle.close();
        }
        return bufferedImage;
    }

    public static BufferedImage getImage(ImageReader imageReader) throws IOException, NullPointerException {
        return imageReader.read(0);
    }

    public static void writeImage(BufferedImage image, String path, String type) {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));){
            ImageIO.write((RenderedImage)image, type, bos);
        }
        catch (IOException e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
    }

    public static boolean isRightFilePath(String path) {
        File file = new File(path = path.trim());
        return file.exists() && file.isFile();
    }

    public static boolean isImageFile(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return false;
        }
        String fileName = file.getName().toLowerCase();
        return fileName.contains(".") && SupportPictureExtension.contains(fileName.substring(fileName.lastIndexOf(".")));
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public static BufferedImage castToTYPEINTRGB(BufferedImage src) {
        BufferedImage convertedImage = new BufferedImage(src.getWidth(), src.getHeight(), 1);
        convertedImage.getGraphics().drawImage(src, 0, 0, null);
        return convertedImage;
    }

    public static VolatileImage convert(BufferedImage source) {
        VolatileImage volatileImage;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        while ((volatileImage = gc.createCompatibleVolatileImage(source.getWidth(), source.getHeight(), 1)).validate(gc) == 2) {
        }
        Graphics2D g = volatileImage.createGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.dispose();
        return volatileImage;
    }

    public static ImageHandle getImageHandle(File file) throws IOException {
        return GetImageInformation.getImageHandle(file, true);
    }

    public static ImageHandle getImageHandle(File file, boolean EnableExtension) throws IOException {
        Iterator<ImageReader> readers;
        ImageReader imageReader;
        String extension;
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        if (EnableExtension && (extension = GetImageInformation.getFileExtension(file.getPath())) != null && (imageReader = GetImageInformation.getImageReader(readers = ImageIO.getImageReadersBySuffix(extension), iis)) != null) {
            try {
                imageReader.getWidth(0);
                return new ImageHandle(file.getPath(), imageReader, iis);
            }
            catch (Exception e) {
                log.error(ExceptionHandler.getExceptionMessage(e));
                try {
                    return GetImageInformation.getImageHandle(file, false);
                }
                catch (IOException ex) {
                    log.error("Failed to get ImageReader for file: {}", (Object)file.getPath());
                    throw new RuntimeException(ex);
                }
            }
        }
        readers = ImageIO.getImageReaders(iis);
        ImageReader imageReader2 = GetImageInformation.getImageReader(readers, iis);
        imageReader2.getWidth(0);
        return new ImageHandle(file.getPath(), imageReader2, iis);
    }

    private static String getFileExtension(String path) {
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex > 0 && dotIndex < path.length() - 1) {
            return path.substring(dotIndex + 1).toLowerCase();
        }
        return null;
    }

    private static ImageReader getImageReader(Iterator<ImageReader> readers, ImageInputStream iis) {
        ImageReader reader = null;
        if (readers.hasNext()) {
            reader = readers.next();
            reader.setInput(iis, true, true);
        }
        return reader;
    }

    public static Dimension getImageResolution(File file) throws IOException {
        try (ImageHandle imageHandle = GetImageInformation.getImageHandle(file);){
            Dimension dimension = GetImageInformation.getImageResolution(imageHandle.imageReader());
            return dimension;
        }
    }

    public static Dimension getImageResolution(ImageReader imageReader) throws IOException {
        return new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
    }

    public static String getHashcode(File file) {
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[81920];
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead;
            while ((bytesRead = fis.read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
        return String.format("%08x", crc.getValue());
    }

    public static HashMap<String, String> getHashcode(String[] files) {
        try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
            HashMap<String, Future<String>> futures = new HashMap<String, Future<String>>();
            for (String filePath : files) {
                File file = new File(filePath);
                if (file.exists() && !file.isDirectory()) {
                    Future<String> future = executor.submit(() -> GetImageInformation.getHashcode(file));
                    futures.put(filePath, future);
                    continue;
                }
                log.warn("File does not exist or is a directory: {}", (Object)filePath);
            }
            HashMap<String, String> results = new HashMap<String, String>();
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    String hashcode = (String)((Future)entry.getValue()).get();
                    if (hashcode == null) continue;
                    results.put((String)entry.getKey(), hashcode);
                }
                catch (Exception e) {
                    log.error("Failed to compute hashcode for file: {}\n{}", entry.getKey(), (Object)ExceptionHandler.getExceptionMessage(e));
                }
            }
            HashMap<String, String> hashMap = results;
            return hashMap;
        }
    }

    public static String getImageType(File file) throws IOException {
        try (ImageHandle imageHandle = GetImageInformation.getImageHandle(file);){
            String string = GetImageInformation.getImageType(imageHandle.imageReader());
            return string;
        }
    }

    public static String getImageType(ImageReader imageReader) throws IOException {
        return imageReader.getFormatName();
    }

    public static int getBitDepth(String ImagePath) throws IOException {
        BufferedImage image = GetImageInformation.getImage(ImagePath);
        int bitDepth = GetImageInformation.getBitDepth(image);
        image.flush();
        return bitDepth;
    }

    public static int getBitDepth(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Image is null or unsupported format");
        }
        return image.getColorModel().getPixelSize();
    }

    public static boolean isOriginalJavaSupportedPictureType(String path) {
        return path.endsWith(".png") || path.endsWith(".jpeg") || path.endsWith(".jpg");
    }

    public static Rectangle getBestSize(String path) throws IOException {
        if (path.startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        Dimension PictureSize = GetImageInformation.getImageResolution(new File(path));
        int SystemWidth = GetSystemSize.width;
        int SystemHeight = GetSystemSize.height;
        int PictureWidth = PictureSize.width;
        int PictureHeight = PictureSize.height;
        int Width = (double)PictureWidth > (double)SystemWidth * 0.8 ? (int)((double)SystemWidth * 0.8) : PictureWidth;
        int Height = (double)PictureHeight > (double)SystemHeight * 0.8 ? (int)((double)SystemHeight * 0.8) : PictureHeight;
        Height += 70;
        Width += 20;
        if ((double)Height < (double)SystemWidth * 0.3) {
            Height = (int)((double)SystemWidth * 0.3);
        }
        if ((double)Width < (double)SystemHeight * 0.5) {
            Width = (int)((double)SystemHeight * 0.5);
        }
        int X = Math.abs((int)(((double)SystemWidth * 0.9 - (double)PictureWidth) / 2.0));
        int Y = Math.abs((int)(((double)SystemHeight * 0.9 - (double)PictureHeight) / 2.0));
        return new Rectangle(X, Y, Width, Height);
    }

    public static ArrayList<String> getCurrentPathOfPicture(String path) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File pictureOrDir = new File(path);
        File parentDir = pictureOrDir.isFile() ? pictureOrDir.getParentFile() : pictureOrDir;
        for (File file : Objects.requireNonNull(parentDir.listFiles())) {
            if (!GetImageInformation.isImageFile(file)) continue;
            arrayList.add(file.getPath());
        }
        return arrayList;
    }

    static {
        readFormats = ImageIO.getReaderFormatNames();
        SupportPictureExtension = new ArrayList();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        isHardwareAccelerated = gc.getBufferCapabilities().isPageFlipping();
        for (String readFormat : readFormats) {
            SupportPictureExtension.add("." + readFormat.toLowerCase());
        }
    }
}

