/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageDPI.Implements;

import java.io.File;
import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.GetImageInformation;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageDPI.ImageDPI;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageHandle;

public class DefaultImageDpiGetter {
    public static ImageDPI getImageDPI(String path) throws IOException {
        float HorizontalDPI = 72.0f;
        float VerticalDPI = 72.0f;
        try (ImageHandle imageHandle = GetImageInformation.getImageHandle(new File(path));){
            ImageReader imageReader = imageHandle.imageReader();
            IIOMetadata metadata = imageReader.getImageMetadata(0);
            if (metadata.isStandardMetadataFormatSupported()) {
                IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
                IIOMetadataNode horizontalCR = DefaultImageDpiGetter.getNode(root, "HorizontalPixelSize");
                IIOMetadataNode verticalCR = DefaultImageDpiGetter.getNode(root, "VerticalPixelSize");
                if (horizontalCR != null) {
                    HorizontalDPI = Float.parseFloat(horizontalCR.getAttribute("value"));
                } else if (verticalCR != null) {
                    VerticalDPI = Float.parseFloat(verticalCR.getAttribute("value"));
                }
            }
            imageReader.dispose();
        }
        return new ImageDPI(HorizontalDPI, VerticalDPI);
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (!rootNode.item(i).getNodeName().equalsIgnoreCase(nodeName)) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        return null;
    }
}

