/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageDPI.Implements;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.ImageDPI.ImageDPI;

public class WindowsImageDpiGetter {
    private static final Lock operationLock = new ReentrantLock();
    private static Pointer gdiToken;
    private static volatile boolean isInitialized;

    private static void initializeGDIPlus() {
        if (isInitialized) {
            return;
        }
        operationLock.lock();
        try {
            if (!isInitialized) {
                PointerByReference tokenRef = new PointerByReference();
                GDIPlus.GdiplusStartupInput startupInput = new GDIPlus.GdiplusStartupInput();
                int status = GDIPlus.INSTANCE.GdiplusStartup(tokenRef, startupInput, null);
                if (status != 0) {
                    throw new RuntimeException("GDI+ initialization failed, error code: " + status);
                }
                gdiToken = tokenRef.getValue();
                isInitialized = true;
            }
        }
        finally {
            operationLock.unlock();
        }
    }

    private static void shutdownGDIPlus() {
        if (!isInitialized) {
            return;
        }
        operationLock.lock();
        try {
            if (isInitialized && gdiToken != null) {
                GDIPlus.INSTANCE.GdiplusShutdown(gdiToken);
                gdiToken = null;
                isInitialized = false;
            }
        }
        finally {
            operationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageDPI getImageDPI(String filePath) throws IOException {
        WindowsImageDpiGetter.initializeGDIPlus();
        if (!isInitialized) {
            throw new IllegalStateException("GDI+ is not initialized properly");
        }
        operationLock.lock();
        PointerByReference image = new PointerByReference();
        float[] horizontalDpi = new float[1];
        float[] verticalDpi = new float[1];
        try {
            int status = GDIPlus.INSTANCE.GdipLoadImageFromFile(new WString(filePath), image);
            if (status != 0) {
                throw new IOException("Failed to load image [" + filePath + "], error code: " + status);
            }
            status = GDIPlus.INSTANCE.GdipGetImageHorizontalResolution(image.getValue(), horizontalDpi);
            if (status != 0) {
                throw new IOException("Failed to get horizontal DPI, error code: " + status);
            }
            status = GDIPlus.INSTANCE.GdipGetImageVerticalResolution(image.getValue(), verticalDpi);
            if (status != 0) {
                throw new IOException("Failed to get vertical DPI, error code: " + status);
            }
            ImageDPI imageDPI = new ImageDPI(horizontalDpi[0], verticalDpi[0]);
            return imageDPI;
        }
        finally {
            if (image.getValue() != null) {
                GDIPlus.INSTANCE.GdipDisposeImage(image.getValue());
            }
            operationLock.unlock();
        }
    }

    static {
        isInitialized = false;
        Runtime.getRuntime().addShutdownHook(new Thread(WindowsImageDpiGetter::shutdownGDIPlus));
    }

    private static interface GDIPlus
    extends StdCallLibrary {
        public static final GDIPlus INSTANCE = (GDIPlus)Native.load((String)"gdiplus", GDIPlus.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
        public static final int Ok = 0;

        public int GdiplusStartup(PointerByReference var1, GdiplusStartupInput var2, Pointer var3);

        public void GdiplusShutdown(Pointer var1);

        public int GdipLoadImageFromFile(WString var1, PointerByReference var2);

        public int GdipGetImageHorizontalResolution(Pointer var1, float[] var2);

        public int GdipGetImageVerticalResolution(Pointer var1, float[] var2);

        public int GdipDisposeImage(Pointer var1);

        public static class GdiplusStartupInput
        extends Structure {
            public int GdiplusVersion = 1;
            public Pointer DebugEventCallback;
            public boolean SuppressBackgroundThread = false;
            public boolean SuppressExternalCodecs = false;

            protected List<String> getFieldOrder() {
                return Arrays.asList("GdiplusVersion", "DebugEventCallback", "SuppressBackgroundThread", "SuppressExternalCodecs");
            }
        }
    }
}

