/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ImageManager;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.PicturePlayer.Loading.Init;
import top.nserly.PicturePlayer.Utils.ImageManager.Info.GetImageInformation;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.String.RandomString;

public record PictureInformationStorageManagement(TreeMap<String, ArrayList<String>> treeMap) implements Serializable
{
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PictureInformationStorageManagement.class);
    private static final String saveDir = "cache/PictureCache/";
    private static final String saveType = "png";
    private static final String FileSuffix = ".png";

    public PictureInformationStorageManagement() {
        this(new TreeMap<String, ArrayList<String>>());
    }

    public String getCachedPicturePath(String OriginalPicturePath) {
        return this.getCachedPicturePath(OriginalPicturePath, GetImageInformation.getHashcode(new File(OriginalPicturePath)));
    }

    public String getCachedPicturePath(String originalPicturePath, String originalPictureHashCode) {
        ArrayList<Object> pictureInformation;
        File originalPicture = new File(originalPicturePath);
        if (!originalPicture.exists()) {
            return originalPicturePath;
        }
        if (GetImageInformation.isOriginalJavaSupportedPictureType(originalPicturePath)) {
            return originalPicturePath;
        }
        if (this.treeMap.containsKey(originalPicturePath)) {
            pictureInformation = this.treeMap.get(originalPicturePath);
            File cachedPicture = new File((String)pictureInformation.get(1));
            if (((String)pictureInformation.get(0)).equals(originalPictureHashCode) && cachedPicture.exists() && PictureInformationStorageManagement.hashcodeEquals(cachedPicture.getPath(), (String)pictureInformation.get(2))) {
                return cachedPicture.getPath();
            }
            this.treeMap.remove(originalPicturePath);
        }
        pictureInformation = new ArrayList<String>();
        pictureInformation.add(originalPictureHashCode);
        File savePath = new File(saveDir + RandomString.getRandomString(10) + FileSuffix);
        pictureInformation.add(savePath.getPath());
        try {
            BufferedImage bufferedImage = GetImageInformation.getImage(originalPicturePath);
            GetImageInformation.writeImage(bufferedImage, savePath.getPath(), saveType);
            pictureInformation.add(GetImageInformation.getHashcode(savePath));
            this.treeMap.put(originalPicturePath, pictureInformation);
            if (bufferedImage != null) {
                bufferedImage.flush();
            }
        }
        catch (Exception e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
            return null;
        }
        return savePath.getPath();
    }

    public void removePictureCache(String OriginalPicturePath) {
        if (this.treeMap == null) {
            return;
        }
        String cachedPicture = this.treeMap.get(OriginalPicturePath).get(1);
        File cachedPictureFile = new File(cachedPicture);
        if (cachedPictureFile.exists() && !cachedPictureFile.delete()) {
            throw new RuntimeException("Deleting the image cache failed: " + cachedPicture);
        }
        this.treeMap.remove(OriginalPicturePath);
    }

    public void clear() {
        this.treeMap.clear();
        Init.clearDirectory(new File(saveDir));
    }

    public void optimize() {
        if (this.treeMap == null || this.treeMap.isEmpty()) {
            this.clear();
            return;
        }
        ConcurrentHashMap cacheToDelete = new ConcurrentHashMap();
        try (ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());){
            for (Map.Entry<String, ArrayList<String>> entry : this.treeMap.entrySet()) {
                String originalPicturePath = entry.getKey();
                ArrayList<String> cache = entry.getValue();
                File currentProcessingFile = new File(originalPicturePath);
                File currentProcessingCachedFile = new File(cache.get(1));
                executorService.submit(() -> {
                    if (!(currentProcessingFile.exists() && currentProcessingCachedFile.exists() && !GetImageInformation.isOriginalJavaSupportedPictureType(originalPicturePath) && PictureInformationStorageManagement.hashcodeEquals(originalPicturePath, (String)cache.get(0)) && PictureInformationStorageManagement.hashcodeEquals(currentProcessingCachedFile.getPath(), (String)cache.get(2)))) {
                        ConcurrentHashMap concurrentHashMap = cacheToDelete;
                        synchronized (concurrentHashMap) {
                            cacheToDelete.put(originalPicturePath, cache);
                        }
                    }
                });
            }
        }
        for (Map.Entry entry : cacheToDelete.entrySet()) {
            this.removePictureCache((String)entry.getKey());
        }
    }

    public static boolean hashcodeEquals(String filePath, String hashcode) {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        return Objects.equals(GetImageInformation.getHashcode(file), hashcode);
    }
}

