/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Utils.ProxyServer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.PicturePlayer.Utils.ProxyServer.ProxyServerFileManage;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public class ProxyServerHandle {
    public final File savePath;
    private static final Logger log = LoggerFactory.getLogger(ProxyServerHandle.class);
    private ProxyServerFileManage fileManager;

    public ProxyServerHandle(String savePath) {
        this.savePath = new File(savePath);
        this.fileManager = new ProxyServerFileManage();
        if (!this.savePath.exists()) {
            try {
                if (!this.savePath.createNewFile()) {
                    log.warn("{} cannot create", (Object)this.savePath.getPath());
                }
            }
            catch (IOException e) {
                log.error(ExceptionHandler.getExceptionMessage(e));
            }
        }
    }

    public void refresh() {
        try {
            FileInputStream fileIn = new FileInputStream(this.savePath);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            this.fileManager = (ProxyServerFileManage)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
            this.fileManager = new ProxyServerFileManage();
            this.save();
        }
    }

    public String getCurrentSelectionProxyServerName() {
        return this.fileManager.currentSelectedProxyServerName;
    }

    public void setCurrentSelectionProxyServerName(String ProxyServerName) {
        if (this.containsProxyServerName(ProxyServerName)) {
            this.fileManager.currentSelectedProxyServerName = ProxyServerName;
        }
    }

    public void delete(String ProxyServerName) {
        this.fileManager.treemap.remove(ProxyServerName);
    }

    public void add(String ProxyServerName, String ProxyServerAddress) {
        if (this.fileManager.treemap.containsKey(ProxyServerName)) {
            this.fileManager.treemap.replace(ProxyServerName, ProxyServerAddress);
        } else {
            this.fileManager.treemap.put(ProxyServerName, ProxyServerAddress);
        }
    }

    public boolean containsProxyServerAddress(String ProxyServerAddress) {
        return this.fileManager.treemap.containsValue(ProxyServerAddress);
    }

    public boolean containsProxyServerName(String ProxyServerName) {
        return this.fileManager.treemap.containsKey(ProxyServerName);
    }

    public TreeMap<String, String> getAllProxyServers() {
        return this.fileManager.treemap;
    }

    public Set<String> getAllProxyServerNames() {
        return this.fileManager.treemap.keySet();
    }

    public Collection<String> getAllProxyServerAddress() {
        return this.fileManager.treemap.values();
    }

    public String getProxyServerAddress(String ProxyServerName) {
        return this.fileManager.treemap.get(ProxyServerName);
    }

    public void save() {
        if (!this.containsProxyServerName(this.fileManager.currentSelectedProxyServerName)) {
            this.fileManager.currentSelectedProxyServerName = "";
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(this.savePath);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(this.fileManager);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
    }
}

