/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Version.DownloadChecker;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.GUIStarter;
import top.nserly.PicturePlayer.Command.CommandHandle;
import top.nserly.PicturePlayer.Loading.Bundle;
import top.nserly.PicturePlayer.NComponent.Frame.DownloadUpdateFrame;
import top.nserly.PicturePlayer.Version.DownloadChecker.CheckAndDownloadUpdate;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.String.StringFormation;

public class AdvancedDownloadSpeed {
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.##");
    public Thread DaemonUpdate;
    private final JProgressBar totalProgress;
    private final JProgressBar currentFileProgress;
    private final JLabel speedLabel;
    private final JLabel DownloadCounting;
    private final StringFormation TotalFormation = new StringFormation("{Speed} - {FinishedSize}/{TotalSize},{NeedTime}");
    private final StringFormation totalFormation;
    private final CheckAndDownloadUpdate downloadUpdate;
    private StringFormation currentFormation;
    private static final Logger logger = LoggerFactory.getLogger(AdvancedDownloadSpeed.class);

    public AdvancedDownloadSpeed(CheckAndDownloadUpdate downloadUpdate, JProgressBar totalProgress, JProgressBar currentFileProgress, JLabel speedLabel, JLabel DownloadCounting) {
        this.totalProgress = totalProgress;
        this.currentFileProgress = currentFileProgress;
        this.speedLabel = speedLabel;
        this.DownloadCounting = DownloadCounting;
        this.downloadUpdate = downloadUpdate;
        totalProgress.setMaximum(downloadUpdate.getUpdateWebSide().size());
        totalProgress.setValue(0);
        totalProgress.setStringPainted(true);
        StringFormation formation = new StringFormation(DownloadCounting.getText());
        formation.add("total", String.valueOf(downloadUpdate.getUpdateWebSide().size()));
        this.totalFormation = new StringFormation(formation.getProcessingString());
        currentFileProgress.setMaximum(100);
        currentFileProgress.setValue(0);
        currentFileProgress.setStringPainted(true);
        this.DaemonUpdate = new Thread(() -> {
            Map<String, ArrayList<?>> map = downloadUpdate.download();
            if (map == null) {
                DownloadUpdateFrame.downloadUpdateFrame.dispose();
                return;
            }
            String website = "";
            try {
                boolean isFound = false;
                for (String websites : downloadUpdate.FilePath) {
                    if (map.get(websites) == null) continue;
                    isFound = true;
                    website = websites;
                }
                if (!isFound) {
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String s : map.keySet()) {
                    arrayList.add((String)map.get(s).getFirst());
                }
                arrayList.remove((String)map.get(downloadUpdate.MainFileWebSite).getFirst());
                CommandHandle.moveFileToLibDirectory(arrayList);
                CommandHandle.moveFileToDirectory((String)map.get(downloadUpdate.MainFileWebSite).getFirst());
                String osType = CommandHandle.detectOSType();
                String OpenedPicturePath = null;
                if (GUIStarter.main != null && GUIStarter.paintPicture != null && GUIStarter.paintPicture.imageCanvas != null) {
                    OpenedPicturePath = GUIStarter.paintPicture.imageCanvas.getPath();
                }
                CommandHandle.executeOSSpecificCommands(osType, (String)map.get(website).getFirst(), OpenedPicturePath);
            }
            catch (IOException | ExceptionInInitializerError | NoClassDefFoundError e) {
                logger.error(ExceptionHandler.getExceptionMessage(e));
                JOptionPane.showMessageDialog(DownloadUpdateFrame.downloadUpdateFrame, Bundle.getMessage("UpdateError_Content") + "\nCaused by:" + String.valueOf(e), Bundle.getMessage("UpdateError_Title"), 0);
                DownloadUpdateFrame.downloadUpdateFrame.dispose();
                GUIStarter.main.setVisible(true);
            }
        });
        this.DaemonUpdate.start();
        this.simulateDownload();
    }

    private void simulateDownload() {
        Timer totalTimer = new Timer(200, this::updateTotalProgress);
        Timer fileTimer = new Timer(200, this::updateFileProgress);
        totalTimer.start();
        fileTimer.start();
    }

    private void updateTotalProgress(ActionEvent actionEvent) {
        int totalFiles = this.downloadUpdate.TotalDownloadingFile;
        int currentProgressFile = this.downloadUpdate.HaveDownloadedFile;
        this.totalProgress.setMaximum(this.downloadUpdate.getUpdateWebSide().size() * 100);
        if (this.downloadUpdate.CurrentFileDownloader.isCompleted()) {
            this.totalFormation.add("current", String.valueOf(totalFiles));
            this.DownloadCounting.setText(this.totalFormation.getProcessingString());
            this.totalProgress.setValue(this.totalProgress.getMaximum());
            this.stopTimer((Timer)actionEvent.getSource());
        } else {
            this.totalProgress.setValue(100 * currentProgressFile + (int)this.downloadUpdate.CurrentFileDownloader.getProgress());
            this.totalFormation.add("current", String.valueOf(currentProgressFile + 1));
            this.DownloadCounting.setText(this.totalFormation.getProcessingString());
        }
    }

    private void updateFileProgress(ActionEvent actionEvent) {
        if (this.downloadUpdate.CurrentFileDownloader == null || this.downloadUpdate.CurrentFileDownloader.getProgress() >= 100.0) {
            this.handleFileCompletion(actionEvent);
        } else {
            this.currentFileProgress.setValue((int)this.downloadUpdate.CurrentFileDownloader.getProgress());
            this.updateSpeedAndSizeLabels();
        }
    }

    private void handleFileCompletion(ActionEvent actionEvent) {
        this.currentFileProgress.setValue(100);
        this.speedLabel.setText("0B/s - " + AdvancedDownloadSpeed.formatBytes(this.downloadUpdate.CurrentFileDownloader.getBytesRead()));
        this.stopTimer((Timer)actionEvent.getSource());
    }

    private void updateSpeedAndSizeLabels() {
        if (this.currentFormation == null) {
            this.currentFormation = this.TotalFormation;
        }
        this.currentFormation.add("Speed", this.formatSpeed(this.downloadUpdate.CurrentFileDownloader.getSpeedBytesPerSecond()));
        this.currentFormation.add("FinishedSize", AdvancedDownloadSpeed.formatBytes(this.downloadUpdate.CurrentFileDownloader.getBytesRead()));
        if (this.downloadUpdate.CurrentFileDownloader.getFileSize() != -1L) {
            this.currentFormation.add("TotalSize", AdvancedDownloadSpeed.formatBytes(this.downloadUpdate.CurrentFileDownloader.getFileSize()));
            this.currentFormation.add("NeedTime", this.formatTimes(this.downloadUpdate.CurrentFileDownloader.getRemainingSeconds()));
        }
        this.speedLabel.setText(this.currentFormation.getProcessingString());
    }

    private void stopTimer(Timer timer) {
        if (timer != null && timer.isRunning()) {
            timer.stop();
        }
    }

    private String formatSpeed(double bytesPerSecond) {
        return AdvancedDownloadSpeed.formatBytes(bytesPerSecond);
    }

    public static String formatBytes(double bytes) {
        if (bytes >= 1.099511627776E12) {
            return decimalFormat.format(bytes / 1.099511627776E12) + "TB";
        }
        if (bytes >= 1.073741824E9) {
            return decimalFormat.format(bytes / 1.073741824E9) + "GB";
        }
        if (bytes >= 1048576.0) {
            return decimalFormat.format(bytes / 1048576.0) + "MB";
        }
        if (bytes >= 1024.0) {
            return decimalFormat.format(bytes / 1024.0) + "KB";
        }
        return decimalFormat.format(bytes) + "B";
    }

    private String formatTimes(long seconds) {
        if (seconds >= 2592000L) {
            return decimalFormat.format(seconds / 2592000L) + "months" + this.formatTimes(seconds % 2592000L);
        }
        if (seconds >= 86400L) {
            return decimalFormat.format(seconds / 86400L) + "days" + this.formatTimes(seconds % 86400L);
        }
        if (seconds >= 3600L) {
            return decimalFormat.format(seconds / 3600L) + "h" + this.formatTimes(seconds % 3600L);
        }
        if (seconds >= 60L) {
            return decimalFormat.format(seconds / 60L) + "min" + this.formatTimes(seconds % 60L);
        }
        return seconds + "s";
    }
}

