/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.PicturePlayer.Version.DownloadChecker;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.GUIStarter;
import top.nserly.PicturePlayer.Exception.UpdateException;
import top.nserly.PicturePlayer.Loading.Bundle;
import top.nserly.PicturePlayer.NComponent.Frame.DownloadUpdateFrame;
import top.nserly.PicturePlayer.Version.PicturePlayerVersion;
import top.nserly.PicturePlayer.Version.VersionID;
import top.nserly.SoftwareCollections_API.DownloadFile.FileDownloader;
import top.nserly.SoftwareCollections_API.FileHandle.FileContents;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public class CheckAndDownloadUpdate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckAndDownloadUpdate.class);
    File f;
    String webSide;
    public List<String> downloadFileWebSite;
    public String MainFileWebSite;
    public ArrayList<String> DependenciesWebSite;
    public int TotalDownloadingFile;
    public int HaveDownloadedFile;
    public FileDownloader CurrentFileDownloader;
    private static final long startTime = System.currentTimeMillis();
    public List<String> FilePath = new ArrayList<String>();
    private static boolean EnableSecureConnection = true;
    public long NewVersionID = 0L;
    public String NewVersionName = "";
    public VersionID versionID;
    private boolean StopToUpdate;
    private final Object[] options = new Object[]{Bundle.getMessage("DownloadUpdateOptions_1st"), Bundle.getMessage("DownloadUpdateOptions_2nd"), Bundle.getMessage("DownloadUpdateOptions_3rd")};
    private static boolean isChecked = false;
    public static final ArrayList<String> DependenciesName = new ArrayList();
    public static final TreeMap<String, String> DependenciesFilePath = new TreeMap();

    public CheckAndDownloadUpdate(String DownloadPath, String webSide) {
        this.webSide = webSide;
        this.f = new File(DownloadPath);
        if (this.f.exists() || this.f.isDirectory()) {
            this.setDefaultDownloadPath();
        }
    }

    public CheckAndDownloadUpdate(String webSide) {
        this.webSide = webSide;
        this.setDefaultDownloadPath();
    }

    public void setDefaultDownloadPath() {
        this.f = new File("./download/" + startTime + "/");
    }

    public static void secureConnection(boolean Enable) {
        if (EnableSecureConnection != Enable) {
            if (!Enable) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                }};
                try {
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
                log.warn("SSL validation is turned off and your computer may be vulnerable!");
            } else {
                try {
                    SSLContext sc = SSLContext.getInstance("TLS");
                    sc.init(null, null, null);
                    SSLSocketFactory ssf = sc.getSocketFactory();
                    HttpsURLConnection.setDefaultSSLSocketFactory(ssf);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    log.error(ExceptionHandler.getExceptionMessage(e));
                    return;
                }
                log.info("SSL validation is enabled");
            }
        }
        EnableSecureConnection = Enable;
    }

    public List<String> getUpdateWebSide() {
        this.StopToUpdate = false;
        if (!isChecked) {
            try {
                return this.checkIfTheLatestVersion() ? this.downloadFileWebSite : null;
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return this.downloadFileWebSite;
    }

    public boolean checkIfTheLatestVersion() throws IOException {
        this.StopToUpdate = false;
        isChecked = true;
        log.info("Checking version...");
        AtomicReference exception = new AtomicReference();
        FileDownloader fileDownloader = new FileDownloader(this.webSide, this.f.getPath());
        fileDownloader.setDownloadErrorHandler((e, f) -> exception.set(e));
        fileDownloader.startDownload();
        if (exception.get() != null) {
            throw (IOException)exception.get();
        }
        this.versionID = (VersionID)VersionID.gson.fromJson(FileContents.read(fileDownloader.getFinalPath()), VersionID.class);
        File file = new File(fileDownloader.getFinalPath());
        if (!file.delete()) {
            log.warn("{} cannot delete", (Object)file.getPath());
        }
        if (this.versionID != null) {
            this.NewVersionID = Long.parseLong(VersionID.getString(this.versionID.getNormalVersionID(), this.versionID.getSpecialFields()));
        }
        if (this.versionID != null) {
            this.NewVersionName = VersionID.getString(this.versionID.getNormalVersion(), this.versionID.getSpecialFields());
        }
        if (this.versionID != null) {
            this.MainFileWebSite = VersionID.getString(this.versionID.getNormalVersionMainFile(), this.versionID.getSpecialFields());
        }
        this.DependenciesWebSite = new ArrayList();
        TreeMap<String, String> cache = null;
        if (this.versionID != null) {
            cache = this.versionID.getNormalDependencies();
        }
        if (cache != null) {
            for (String value : cache.values()) {
                String dependenciesWebsite = VersionID.getString(value, this.versionID.getSpecialFields());
                String dependenciesName = dependenciesWebsite.replace("\\", "/");
                if (DependenciesName.contains(dependenciesName = dependenciesName.substring(dependenciesName.lastIndexOf("/") + 1, dependenciesName.lastIndexOf(".jar")))) continue;
                this.DependenciesWebSite.add(VersionID.getString(dependenciesWebsite, this.versionID.getSpecialFields()));
            }
        }
        this.downloadFileWebSite = new ArrayList<String>(this.DependenciesWebSite);
        this.downloadFileWebSite.add(this.MainFileWebSite);
        if (this.NewVersionID <= Long.parseLong(PicturePlayerVersion.getVersionID())) {
            log.info("You are using the latest version: {}", (Object)PicturePlayerVersion.getVersionID());
            return false;
        }
        log.info("New version found: {} ({})", (Object)this.NewVersionID, (Object)this.NewVersionName);
        log.info("Download file web site: {}", this.downloadFileWebSite);
        if (this.downloadFileWebSite.isEmpty()) {
            log.warn("No files to download!");
            return false;
        }
        return true;
    }

    public Map<String, ArrayList<?>> download(List<String> downloadWebSide) {
        this.StopToUpdate = false;
        HashMap finalA = new HashMap();
        if (downloadWebSide == null) {
            return null;
        }
        int index = 0;
        this.TotalDownloadingFile = downloadWebSide.size();
        block4: for (String down : downloadWebSide) {
            this.FilePath.add(down);
            this.HaveDownloadedFile = index++;
            switch (this.download(down, finalA, false)) {
                case 1: {
                    --this.TotalDownloadingFile;
                    continue block4;
                }
                case 2: {
                    return null;
                }
            }
        }
        if (finalA.isEmpty()) {
            return null;
        }
        log.info("Download completed!");
        return finalA;
    }

    private int download(String down, Map<String, ArrayList<?>> finalA, boolean isTry) {
        try {
            if (this.StopToUpdate) {
                throw new UpdateException("Update ended,cause of User terminated software update");
            }
            if (!isTry) {
                this.CurrentFileDownloader = new FileDownloader(down, this.f.getPath());
            }
            this.CurrentFileDownloader.setDownloadErrorHandler((e, fileDownloader) -> {
                if (this.exceptionHandling(e) == 0) {
                    this.download(down, finalA, true);
                } else {
                    this.CurrentFileDownloader.stopDownload();
                    DownloadUpdateFrame.downloadUpdateFrame.dispose();
                    GUIStarter.main.setVisible(true);
                    this.stopToUpdate();
                }
            });
            log.info("Downloading {}", (Object)down);
            if (!EnableSecureConnection) {
                log.warn("The connection is not secure from {}!", (Object)down);
            }
            this.CurrentFileDownloader.startDownload();
            ArrayList<Object> list = new ArrayList<Object>();
            String cache = this.CurrentFileDownloader.getFinalPath();
            if (this.StopToUpdate) {
                throw new UpdateException("Update ended,cause of User terminated software update");
            }
            if (cache != null) {
                list.add(cache);
                list.add(this.CurrentFileDownloader);
                finalA.put(down, list);
            }
        }
        catch (UpdateException e2) {
            log.error(e2.getMessage());
            return 2;
        }
        if (this.CurrentFileDownloader.isCompleted()) {
            return 0;
        }
        return 1;
    }

    public Map<String, ArrayList<?>> download() {
        this.StopToUpdate = false;
        return this.download(this.getUpdateWebSide());
    }

    public List<?> downloadDescribe() {
        log.info("Start downloading describe version file...");
        this.StopToUpdate = false;
        String DescribeFileWebSide = VersionID.getString(this.versionID.getNormalVersionDescribe(), this.versionID.getSpecialFields());
        if (DescribeFileWebSide != null && !DescribeFileWebSide.isEmpty()) {
            return this.download(Collections.singletonList(DescribeFileWebSide)).get(DescribeFileWebSide);
        }
        return null;
    }

    public void stopToUpdate() {
        this.StopToUpdate = true;
        this.CurrentFileDownloader.stopDownload();
    }

    private int exceptionHandling(IOException e) {
        log.error(e.getMessage());
        return JOptionPane.showOptionDialog(null, Bundle.getMessage("DownloadUpdateError_Content") + "\n" + String.valueOf(e), Bundle.getMessage("DownloadUpdateError_Title"), -1, 3, null, this.options, this.options);
    }

    @Generated
    public void setWebSide(String webSide) {
        this.webSide = webSide;
    }

    static {
        File[] files = new File("lib").listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!file.isFile() || !fileName.endsWith(".jar")) continue;
                String DependencyName = fileName.substring(0, fileName.lastIndexOf(".jar"));
                DependenciesName.add(DependencyName);
                DependenciesFilePath.put(DependencyName, file.getPath());
            }
        }
    }
}

