/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TwoWayMap<K, V> {
    private final Map<K, V> keyToValue = new HashMap();
    private final Map<V, K> valueToKey = new HashMap<V, K>();

    public void put(K key, V value) {
        if (this.keyToValue.containsKey(key)) {
            V oldValue = this.keyToValue.get(key);
            this.valueToKey.remove(oldValue);
        }
        if (this.valueToKey.containsKey(value)) {
            K oldKey = this.valueToKey.get(value);
            this.keyToValue.remove(oldKey);
        }
        this.keyToValue.put(key, value);
        this.valueToKey.put(value, key);
    }

    public V getValue(K key) {
        return this.keyToValue.get(key);
    }

    public K getKey(V value) {
        return this.valueToKey.get(value);
    }

    public void removeByKey(K key) {
        V value = this.keyToValue.remove(key);
        if (value != null) {
            this.valueToKey.remove(value);
        }
    }

    public Collection<V> values() {
        return this.keyToValue.values();
    }

    public Set<V> valueSet() {
        return this.valueToKey.keySet();
    }

    public Collection<K> keys() {
        return this.valueToKey.values();
    }

    public Set<K> keySet() {
        return this.keyToValue.keySet();
    }

    public void clear() {
        this.keyToValue.clear();
        this.valueToKey.clear();
    }

    public boolean isEmpty() {
        return this.keyToValue.isEmpty() || this.valueToKey.isEmpty();
    }
}

