/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.DownloadFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Collections.TwoWayMap;
import top.nserly.SoftwareCollections_API.DownloadFile.DownloadErrorHandler;
import top.nserly.SoftwareCollections_API.DownloadFile.FileDownloader;

public class FileDownloaderControl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileDownloaderControl.class);
    private final TwoWayMap<String, FileDownloader> activeDownloads = new TwoWayMap();
    private final Map<String, String> completedDownloads = new ConcurrentHashMap<String, String>();
    private final Queue<DownloadTask> downloadQueue = new LinkedList<DownloadTask>();
    private final ExecutorService downloadExecutor;
    private final int maxConcurrentDownloads;
    private final ReentrantLock queueLock = new ReentrantLock();
    private final Condition queueCondition;
    private long globalSpeedLimitBytesPerSecond = -1L;
    private volatile boolean isRunning = true;

    public FileDownloaderControl(int maxConcurrentDownloads) {
        if (maxConcurrentDownloads < 1) {
            throw new IllegalArgumentException("The maximum number of concurrent events cannot be less than 1");
        }
        this.maxConcurrentDownloads = maxConcurrentDownloads;
        this.downloadExecutor = new ThreadPoolExecutor(maxConcurrentDownloads, maxConcurrentDownloads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "download-worker-" + System.currentTimeMillis()), new ThreadPoolExecutor.DiscardPolicy(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                log.warn("The download task is rejected and the current thread pool is full");
                if (r instanceof DownloadRunnable) {
                    DownloadRunnable runnable = (DownloadRunnable)r;
                    if (runnable.task.errorHandler != null) {
                        runnable.task.errorHandler.handler(new IOException("There are too many download tasks to handle"), null);
                    }
                }
            }
        });
        this.queueCondition = this.queueLock.newCondition();
        this.startQueueProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTask(String taskId) {
        if (taskId == null) {
            return false;
        }
        this.queueLock.lock();
        try {
            FileDownloader activeDownloader = this.activeDownloads.getValue(taskId);
            if (activeDownloader != null) {
                activeDownloader.stopDownload();
                this.activeDownloads.removeByKey(taskId);
                boolean bl = true;
                return bl;
            }
            Iterator queueIterator = this.downloadQueue.iterator();
            while (queueIterator.hasNext()) {
                DownloadTask task = (DownloadTask)queueIterator.next();
                if (!task.taskId.equals(taskId)) continue;
                if (!task.chunkTaskIds.isEmpty()) {
                    for (String chunkId : task.chunkTaskIds) {
                        this.removeTask(chunkId);
                    }
                }
                queueIterator.remove();
                boolean bl = true;
                return bl;
            }
            for (DownloadTask task : this.downloadQueue) {
                if (!task.chunkTaskIds.contains(taskId)) continue;
                queueIterator = this.downloadQueue.iterator();
                while (queueIterator.hasNext()) {
                    DownloadTask subTask = (DownloadTask)queueIterator.next();
                    if (!subTask.taskId.equals(taskId)) continue;
                    queueIterator.remove();
                    task.chunkTaskIds.remove(taskId);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public void waitTillDownload(String taskID) throws InterruptedException {
        FileDownloader downloader;
        this.queueLock.lock();
        try {
            do {
                if ((downloader = this.activeDownloads.getValue(taskID)) != null || !this.queueCondition.await(100L, TimeUnit.MILLISECONDS)) continue;
                log.warn("Stopped waiting for the download thread to be terminated by other threads");
            } while (downloader == null && this.isRunning);
        }
        finally {
            this.queueLock.unlock();
        }
        if (downloader == null) {
            throw new IllegalArgumentException("The task ID does not exist: " + taskID);
        }
        if (downloader.isCompleted() || downloader.isStopped()) {
            return;
        }
        downloader.getDownloadThread().join();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Waiting to be interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addDownloadTask(String url, String saveDir, int threadCount, DownloadErrorHandler errorHandler) {
        if (url == null || saveDir == null) {
            throw new IllegalArgumentException("URLs and save directories cannot be empty");
        }
        String taskId = this.generateTaskId();
        DownloadTask task = new DownloadTask();
        task.url = url;
        task.saveDir = saveDir;
        task.threadCount = Math.max(1, threadCount);
        task.errorHandler = errorHandler;
        task.taskId = taskId;
        task.masterTaskId = null;
        this.queueLock.lock();
        try {
            this.downloadQueue.add(task);
            this.queueCondition.signal();
        }
        finally {
            this.queueLock.unlock();
        }
        return taskId;
    }

    public void waitTillDownload() throws InterruptedException {
        this.queueLock.lock();
        try {
            while (!(Thread.currentThread().isInterrupted() || this.activeDownloads.isEmpty() && this.downloadQueue.isEmpty())) {
                if (!this.queueCondition.await(100L, TimeUnit.MILLISECONDS)) continue;
                log.warn("Stopped waiting for the download thread to be terminated by other threads");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Waiting to be interrupted");
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public Map<String, String> getCompletedDownloads() {
        return Collections.unmodifiableMap(this.completedDownloads);
    }

    private void startQueueProcessor() {
        Thread processor = new Thread(this::processQueue, "download-queue-processor");
        processor.setDaemon(true);
        processor.start();
    }

    private void processQueue() {
        while (this.isRunning) {
            try {
                DownloadTask task = this.takeTaskFromQueue();
                if (task == null) continue;
                this.submitTaskToExecutor(task);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("The queue processor is interrupted");
                break;
            }
            catch (Exception e) {
                log.error("Queue processing error", (Throwable)e);
            }
        }
    }

    private DownloadTask takeTaskFromQueue() throws InterruptedException {
        this.queueLock.lock();
        try {
            while (this.downloadQueue.isEmpty() && this.isRunning) {
                this.queueCondition.await();
            }
            DownloadTask downloadTask = this.isRunning ? this.downloadQueue.poll() : null;
            return downloadTask;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    private void submitTaskToExecutor(DownloadTask task) {
        block4: {
            if (task.threadCount <= 1) {
                FileDownloader downloader = new FileDownloader(task.url, task.saveDir, task.errorHandler);
                this.configureDownloader(downloader);
                this.activeDownloads.put(task.taskId, downloader);
                this.downloadExecutor.submit(new DownloadRunnable(this, task, downloader));
            } else {
                try {
                    this.startMultiThreadDownload(task);
                }
                catch (IOException e) {
                    log.error("Failed to start the shard download", (Throwable)e);
                    if (task.errorHandler == null) break block4;
                    task.errorHandler.handler(e, null);
                }
            }
        }
    }

    private void startMultiThreadDownload(final DownloadTask task) throws IOException {
        String finalFileName;
        long fileSize = this.getFileSize(task.url);
        if (fileSize <= 0L) {
            log.warn("Unable to get file size, downgraded to single-threaded download");
            this.submitSingleThreadTask(task);
            return;
        }
        int threadCount = Math.min(task.threadCount, 10);
        threadCount = Math.min(threadCount, (int)Math.ceil((double)fileSize / 1048576.0));
        threadCount = Math.max(threadCount, 1);
        long chunkSize = fileSize / (long)threadCount;
        String baseFileName = this.getFileNameFromUrl(task.url);
        task.finalFileName = finalFileName = this.generateUniqueFileName(baseFileName, task.saveDir);
        final String tempDir = this.normalizeDirectoryPath(task.saveDir) + ".chunk_" + finalFileName + "_" + System.currentTimeMillis() + "/";
        File tempDirFile = new File(tempDir);
        if (!tempDirFile.mkdirs() && !tempDirFile.exists()) {
            throw new IOException("Unable to create a temporary shard directory: " + tempDir);
        }
        this.activeDownloads.put(task.taskId, null);
        final CountDownLatch chunkLatch = new CountDownLatch(threadCount);
        final DownloadErrorHandler chunkErrorHandler = (e, d) -> {
            log.error("Shard download failed", (Throwable)e);
            task.chunkTaskIds.forEach(chunkId -> {
                FileDownloader chunkDownloader = this.activeDownloads.getValue((String)chunkId);
                if (chunkDownloader != null) {
                    chunkDownloader.stopDownload();
                }
            });
            if (task.errorHandler != null) {
                task.errorHandler.handler(new IOException("Shard download failed", e), null);
            }
            while (chunkLatch.getCount() > 0L) {
                chunkLatch.countDown();
            }
            this.deleteDirectory(new File(tempDir));
        };
        for (int i = 0; i < threadCount; ++i) {
            final long start = (long)i * chunkSize;
            final long end = i == threadCount - 1 ? fileSize - 1L : (long)(i + 1) * chunkSize - 1L;
            final String chunkTaskId = this.generateTaskId();
            task.chunkTaskIds.add(chunkTaskId);
            FileDownloader chunkDownloader = new FileDownloader(this, task.url, tempDir, chunkErrorHandler){
                {
                    Objects.requireNonNull(this$0);
                    super(sourceUrl, saveDirectory, downloadErrorHandler);
                }

                @Override
                public HttpURLConnection createConnection(boolean isResume) throws IOException {
                    HttpURLConnection connection = super.createConnection(isResume);
                    connection.setRequestProperty("Range", "bytes=" + start + "-" + end);
                    return connection;
                }
            };
            chunkDownloader.setFinalFileName("chunk_" + i + "_" + baseFileName);
            this.configureDownloader(chunkDownloader);
            this.activeDownloads.put(chunkTaskId, chunkDownloader);
            this.downloadExecutor.submit(new DownloadRunnable(this, new DownloadTask(this){
                {
                    Objects.requireNonNull(this$0);
                    this.url = task.url;
                    this.saveDir = tempDir;
                    this.threadCount = 1;
                    this.errorHandler = chunkErrorHandler;
                    this.taskId = chunkTaskId;
                    this.masterTaskId = task.taskId;
                }
            }, chunkDownloader){
                {
                    Objects.requireNonNull(this$0);
                    super(this$0, task, downloader);
                }

                @Override
                public void run() {
                    super.run();
                    chunkLatch.countDown();
                }
            });
        }
        this.startMergeThread(tempDir, task.saveDir, finalFileName, chunkLatch, task);
    }

    private void startMergeThread(String tempDir, String saveDir, String finalFileName, CountDownLatch latch, DownloadTask mainTask) {
        Thread mergeThread = new Thread(() -> {
            try {
                latch.await();
                if (this.isAnyChunkFailed(tempDir)) {
                    log.warn("Some chunks failed, aborting merge");
                    this.deleteDirectory(new File(tempDir));
                    return;
                }
                this.mergeChunks(tempDir, this.normalizeDirectoryPath(saveDir) + finalFileName);
                log.info("File merged successfully: {}", (Object)finalFileName);
            }
            catch (InterruptedException e) {
                log.info("Merge thread interrupted");
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error("Failed to merge chunks", (Throwable)e);
                if (mainTask.errorHandler != null) {
                    mainTask.errorHandler.handler(new IOException("Failed to merge chunks", e), null);
                }
            }
            finally {
                this.deleteDirectory(new File(tempDir));
                this.queueLock.lock();
                try {
                    this.activeDownloads.removeByKey(mainTask.taskId);
                    this.completedDownloads.put(mainTask.taskId, finalFileName);
                    this.queueCondition.signal();
                }
                finally {
                    this.queueLock.unlock();
                }
            }
        }, "merge-thread-" + mainTask.taskId);
        mergeThread.setDaemon(true);
        mergeThread.start();
    }

    private void mergeChunks(String tempDir, String targetPath) throws IOException {
        File targetFile = new File(targetPath);
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            File[] chunkFiles = new File(tempDir).listFiles((dir, name) -> name.startsWith("chunk_"));
            if (chunkFiles == null || chunkFiles.length == 0) {
                throw new IOException("No chunk files found for merging");
            }
            Arrays.sort(chunkFiles, (f1, f2) -> {
                int idx1 = Integer.parseInt(f1.getName().split("_")[1]);
                int idx2 = Integer.parseInt(f2.getName().split("_")[1]);
                return Integer.compare(idx1, idx2);
            });
            byte[] buffer = new byte[FileDownloader.getBUFFER_SIZE()];
            for (File chunk : chunkFiles) {
                try (FileInputStream fis = new FileInputStream(chunk);){
                    int bytesRead;
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                }
                if (chunk.delete()) continue;
                log.warn("{} cannot delete", (Object)chunk.getPath());
            }
        }
    }

    private boolean isAnyChunkFailed(String tempDir) {
        File[] chunkFiles = new File(tempDir).listFiles((dir, name) -> name.startsWith("chunk_"));
        if (chunkFiles == null) {
            return true;
        }
        for (File chunk : chunkFiles) {
            if (chunk.length() != 0L) continue;
            return true;
        }
        return false;
    }

    private String generateUniqueFileName(String baseName, String saveDir) {
        Object name = baseName;
        int counter = 1;
        File targetFile = new File(this.normalizeDirectoryPath(saveDir) + (String)name);
        while (targetFile.exists()) {
            int dotIndex = baseName.lastIndexOf(46);
            name = dotIndex > 0 ? baseName.substring(0, dotIndex) + "(" + counter + ")" + baseName.substring(dotIndex) : baseName + "(" + counter + ")";
            ++counter;
            targetFile = new File(this.normalizeDirectoryPath(saveDir) + (String)name);
        }
        return name;
    }

    private String generateTaskId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private void submitSingleThreadTask(DownloadTask task) {
        FileDownloader downloader = new FileDownloader(task.url, task.saveDir, task.errorHandler);
        this.configureDownloader(downloader);
        this.activeDownloads.put(task.taskId, downloader);
        this.downloadExecutor.submit(new DownloadRunnable(this, task, downloader));
    }

    private void configureDownloader(FileDownloader downloader) {
        if (this.globalSpeedLimitBytesPerSecond > 0L) {
            downloader.setMaxSpeedBytesPerSecond(this.globalSpeedLimitBytesPerSecond);
        }
    }

    private boolean deleteDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                log.warn("Files cannot be deleted: {}", (Object)file.getAbsolutePath());
            }
        }
        return dir.delete();
    }

    private long getFileSize(String url) throws IOException {
        HttpURLConnection connection = null;
        try {
            URL urlObj = URL.of(URI.create(url), null);
            connection = (HttpURLConnection)urlObj.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 206) {
                long l = connection.getContentLengthLong();
                return l;
            }
            throw new IOException("HEAD request fails, response code: " + responseCode);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String getFileNameFromUrl(String url) {
        try {
            URL urlObj = URL.of(URI.create(url), null);
            String path = urlObj.getPath();
            int lastSlash = path.lastIndexOf(47);
            return lastSlash == -1 ? path : path.substring(lastSlash + 1);
        }
        catch (Exception e) {
            log.error("Failed to resolve file name from URL", (Throwable)e);
            return "unknown_file_" + System.currentTimeMillis();
        }
    }

    private String normalizeDirectoryPath(String path) {
        if (path == null || path.isEmpty()) {
            return "./";
        }
        return (path = path.replace("\\", "/")).endsWith("/") ? path : path + "/";
    }

    public void setGlobalSpeedLimit(long bytesPerSecond) {
        this.globalSpeedLimitBytesPerSecond = bytesPerSecond;
        this.activeDownloads.values().forEach(this::configureDownloader);
    }

    public void pauseAll() {
        this.activeDownloads.values().forEach(FileDownloader::stopDownload);
    }

    public void resumeAll() {
        this.activeDownloads.values().forEach(downloader -> {
            if (downloader != null && !downloader.isCompleted() && !downloader.isStopped()) {
                downloader.startDownloadInNewThread();
            }
        });
    }

    public void stopAll() {
        this.isRunning = false;
        this.activeDownloads.values().forEach(downloader -> {
            if (downloader != null) {
                downloader.stopDownload();
            }
        });
        this.downloadExecutor.shutdownNow();
        try {
            if (!this.downloadExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                log.warn("The thread pool fails to close gracefully");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.queueLock.lock();
        try {
            this.downloadQueue.clear();
            this.queueCondition.signal();
        }
        finally {
            this.queueLock.unlock();
        }
        this.activeDownloads.clear();
    }

    public List<FileDownloader> getActiveDownloads() {
        return new ArrayList<FileDownloader>(this.activeDownloads.values());
    }

    public int getQueueSize() {
        this.queueLock.lock();
        try {
            int n = this.downloadQueue.size();
            return n;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public FileDownloader getDownloaderByTaskId(String taskId) {
        return this.activeDownloads.getValue(taskId);
    }

    public boolean removeQueuedTask(String taskId) {
        this.queueLock.lock();
        try {
            boolean bl = this.downloadQueue.removeIf(task -> task.taskId.equals(taskId));
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Generated
    public int getMaxConcurrentDownloads() {
        return this.maxConcurrentDownloads;
    }

    public static class DownloadTask {
        String url;
        String saveDir;
        int threadCount;
        DownloadErrorHandler errorHandler;
        String taskId;
        List<String> chunkTaskIds = new ArrayList<String>();
        String masterTaskId;
        String finalFileName;

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getSaveDir() {
            return this.saveDir;
        }

        @Generated
        public int getThreadCount() {
            return this.threadCount;
        }

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public String getMasterTaskId() {
            return this.masterTaskId;
        }

        @Generated
        public String getFinalFileName() {
            return this.finalFileName;
        }
    }

    private class DownloadRunnable
    implements Runnable {
        private final DownloadTask task;
        private final FileDownloader downloader;
        final /* synthetic */ FileDownloaderControl this$0;

        public DownloadRunnable(FileDownloaderControl fileDownloaderControl, DownloadTask task, FileDownloader downloader) {
            FileDownloaderControl fileDownloaderControl2 = fileDownloaderControl;
            Objects.requireNonNull(fileDownloaderControl2);
            this.this$0 = fileDownloaderControl2;
            this.task = task;
            this.downloader = downloader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.downloader.startDownload();
                if (this.downloader.isCompleted() && !this.downloader.isStopped()) {
                    this.this$0.completedDownloads.put(this.task.taskId, this.downloader.getFinalPath());
                    log.info("Task completion and recording: {}", (Object)this.task.taskId);
                }
                this.this$0.queueLock.lock();
            }
            catch (Throwable throwable) {
                this.this$0.queueLock.lock();
                try {
                    this.this$0.activeDownloads.removeByKey(this.task.taskId);
                    if (this.task.masterTaskId != null) {
                        for (DownloadTask masterTask : this.this$0.downloadQueue) {
                            if (!masterTask.taskId.equals(this.task.masterTaskId)) continue;
                            masterTask.chunkTaskIds.remove(this.task.taskId);
                            break;
                        }
                    }
                    this.this$0.queueCondition.signal();
                    throw throwable;
                }
                finally {
                    this.this$0.queueLock.unlock();
                }
            }
            try {
                this.this$0.activeDownloads.removeByKey(this.task.taskId);
                if (this.task.masterTaskId != null) {
                    for (DownloadTask masterTask : this.this$0.downloadQueue) {
                        if (!masterTask.taskId.equals(this.task.masterTaskId)) continue;
                        masterTask.chunkTaskIds.remove(this.task.taskId);
                        break;
                    }
                }
                this.this$0.queueCondition.signal();
                return;
            }
            finally {
                this.this$0.queueLock.unlock();
            }
        }
    }
}

