/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.FileHandle;

import java.io.File;

public class ComputeFileSize {
    public static FileSize computeFileSize(File file, int precision) {
        if (file == null || !file.exists()) {
            return new FileSize(0.0f, 0);
        }
        long sizeInBytes = file.length();
        return ComputeFileSize.computeFileSize(sizeInBytes, precision);
    }

    public static FileSize computeFileSize(float sizeInBytes, int precision) {
        float size;
        if (sizeInBytes < 0.0f) {
            return new FileSize(0.0f, 0);
        }
        int unit = 0;
        for (size = sizeInBytes; size >= 1024.0f && unit < 8; size /= 1024.0f, ++unit) {
        }
        size = (float)Math.round((double)size * Math.pow(10.0, precision)) / (float)Math.pow(10.0, precision);
        return new FileSize(size, unit);
    }

    public static String formatFileSize(FileSize fileSize) {
        return fileSize.size + " " + FileSize.UNIT_SYMBOLS[fileSize.unit];
    }

    public record FileSize(float size, int unit) {
        public static final int UNIT_B = 0;
        public static final int UNIT_KB = 1;
        public static final int UNIT_MB = 2;
        public static final int UNIT_GB = 3;
        public static final int UNIT_TB = 4;
        public static final int UNIT_PB = 5;
        public static final int UNIT_EB = 6;
        public static final int UNIT_ZB = 7;
        public static final int UNIT_YB = 8;
        public static final String[] UNIT_SYMBOLS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    }
}

