/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.FileHandle;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;

public class FileContents {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileContents.class);

    public static String read(String path) {
        try {
            return FileContents.read(new File(path).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String read(URL url) {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
            return null;
        }
        return content.toString();
    }

    public static void write(String path, String content) {
        try (FileWriter fileWriter = new FileWriter(path);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(content);
            bufferedWriter.flush();
        }
        catch (IOException e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
    }
}

