/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.FileHandle;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarFileRenamer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JarFileRenamer.class);
    private static final Pattern FILENAME_PATTERN = Pattern.compile("(.+?)-(\\d+\\.\\d+\\.\\d+\\.Final)(-.+?)\\.jar$");

    public static HashSet<File> renameJarFile(String dir) throws IOException {
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            throw new IOException(dir + " is not exists!");
        }
        if (!dirFile.isDirectory()) {
            throw new IOException(dir + " is not a directory!");
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (File originalFile : Objects.requireNonNull(dirFile.listFiles())) {
            if (!originalFile.isFile()) continue;
            hashSet.add(JarFileRenamer.renameJarFile(originalFile));
        }
        return hashSet;
    }

    public static File renameJarFile(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            log.warn("File does not exist or is not a valid file: {}", (Object)(file != null ? file.getAbsolutePath() : "null"));
            return file;
        }
        String originalName = file.getName();
        Matcher matcher = FILENAME_PATTERN.matcher(originalName);
        if (matcher.matches()) {
            try {
                boolean renamed;
                String baseName = matcher.group(1);
                String version = matcher.group(2);
                String suffix = matcher.group(3);
                String newFileName = baseName + suffix + "-" + version + ".jar";
                File parentDir = file.getParentFile();
                File newFile = new File(parentDir, newFileName);
                if (newFile.exists()) {
                    if (newFile.delete()) {
                        log.info("Delete old file successfully: {}", (Object)newFileName);
                    } else {
                        log.error("Failed to delete old file: {}", (Object)newFileName);
                    }
                }
                if (renamed = file.renameTo(newFile)) {
                    log.info("Renamed successfully: {} -> {}", (Object)originalName, (Object)newFileName);
                    return newFile;
                }
                log.error("Failed to rename: {}", (Object)originalName);
                return file;
            }
            catch (Exception e) {
                log.error("Error occurred while processing file: {}", (Object)originalName, (Object)e);
                return file;
            }
        }
        log.debug("Filename does not match pattern, no renaming performed: {}", (Object)originalName);
        return file;
    }
}

