/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.FileHandle;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarVersionCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JarVersionCleaner.class);
    private static final Pattern JAR_PATTERN = Pattern.compile("^(.*?)-([0-9]+(\\.[0-9a-zA-Z\\-]+)*)(-[^.]*)?\\.jar$", 2);

    public static HashSet<String> cleanOldVersions(String folderPath, boolean isOnlyGetNeedToDeleteFile) throws IOException {
        HashSet<String> needToDeleteFileCollection = new HashSet<String>();
        File folder = new File(folderPath);
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IOException("Invalid folder path: " + folderPath);
        }
        File[] jarFiles = folder.listFiles((file, name) -> name.toLowerCase().endsWith(".jar"));
        if (jarFiles == null || jarFiles.length == 0) {
            log.error("The JAR file is not found in the folder.");
            return needToDeleteFileCollection;
        }
        HashMap<String, List> jarGroups = new HashMap<String, List>();
        for (File file2 : jarFiles) {
            JarFileInfo jarInfo = JarVersionCleaner.parseJarFileName(file2);
            if (jarInfo != null) {
                jarGroups.computeIfAbsent(jarInfo.baseName, k -> new ArrayList()).add(jarInfo);
                continue;
            }
            log.error("Unable to resolve file name format: {}", (Object)file2.getName());
        }
        for (Map.Entry entry : jarGroups.entrySet()) {
            String baseName = (String)entry.getKey();
            List jarFilesInGroup = (List)entry.getValue();
            if (jarFilesInGroup.size() <= 1) continue;
            log.info("Processing group: {} ; Locate {} files", (Object)baseName, (Object)jarFilesInGroup.size());
            jarFilesInGroup.sort((j1, j2) -> JarVersionCleaner.compareVersions(j2.version, j1.version));
            for (JarFileInfo jarInfo : jarFilesInGroup) {
                log.debug("- {}{}", (Object)jarInfo.file.getName(), (Object)(jarInfo == jarFilesInGroup.getFirst() ? " (keep)" : ""));
            }
            for (int i = 1; i < jarFilesInGroup.size(); ++i) {
                File fileToDelete = ((JarFileInfo)jarFilesInGroup.get((int)i)).file;
                needToDeleteFileCollection.add(fileToDelete.getPath());
                if (isOnlyGetNeedToDeleteFile) continue;
                if (fileToDelete.delete()) {
                    log.debug("Deleted old version: {}", (Object)fileToDelete.getName());
                    continue;
                }
                log.error("File deletion fails: {}", (Object)fileToDelete.getName());
            }
        }
        return needToDeleteFileCollection;
    }

    private static JarFileInfo parseJarFileName(File file) {
        Matcher matcher = JAR_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            String baseName = matcher.group(1);
            String version = matcher.group(2);
            return new JarFileInfo(baseName, version, file);
        }
        return null;
    }

    private static int compareVersions(String version1, String version2) {
        String[] parts1 = version1.split("[.-]");
        String[] parts2 = version2.split("[.-]");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            String part1 = i < parts1.length ? parts1[i] : "";
            String part2 = i < parts2.length ? parts2[i] : "";
            try {
                long num1 = Long.parseLong(part1);
                long num2 = Long.parseLong(part2);
                if (num1 == num2) continue;
                return Long.compare(num1, num2);
            }
            catch (NumberFormatException e) {
                int stringCompare = part1.compareToIgnoreCase(part2);
                if (stringCompare == 0) continue;
                return stringCompare;
            }
        }
        return 0;
    }

    private record JarFileInfo(String baseName, String version, File file) {
    }
}

