/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Handler.Exception;

import org.slf4j.Logger;

public class ExceptionHandler {
    public static void setUncaughtExceptionHandler(Logger log) {
        Thread.setDefaultUncaughtExceptionHandler((e1, e2) -> log.error(ExceptionHandler.getExceptionMessage(e2)));
    }

    public static String getExceptionMessage(Throwable e) {
        Throwable throwable;
        if (e == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(e.getMessage() != null && !e.getMessage().isBlank() ? e.getMessage() : "No Exception Message!").append("\n").append(e.getClass().getName()).append(":").append(e.getMessage()).append("\n");
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        if (stackTraceElements != null) {
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                stringBuilder.append("at ").append(stackTraceElement.getClassName()).append("(line:").append(stackTraceElement.getLineNumber()).append(")\n");
            }
        }
        if ((throwable = e.getCause()) != null) {
            stringBuilder.append("Caused by:").append(ExceptionHandler.getExceptionMessage(throwable));
        }
        return stringBuilder.toString();
    }
}

