/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.SoftwareChannel;

import java.net.Socket;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.SoftwareChannel.WindowsAppMutex;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Interactions;

public final class TCP_Handle
extends Interactions {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TCP_Handle.class);
    public static WindowsAppMutex windowsAppMutex;

    public TCP_Handle(Socket socket, ArrayList<Socket> ClientSockets) {
        super(socket, ClientSockets);
    }

    @Override
    public int messageCall() throws Exception {
        this.handle(this.sendMessage);
        return 0;
    }

    private void handle(String message) throws Exception {
        if (windowsAppMutex == null) {
            throw new RuntimeException("WindowsAppMutex is not initialized. Please set it before handling messages.");
        }
        if (message.startsWith("{newPicturePath} ")) {
            String filePath = message.trim();
            filePath = filePath.substring(filePath.indexOf(" "));
            log.info("Received file path: {}", (Object)filePath);
            if (windowsAppMutex.getHandleSoftwareRequestAction() != null) {
                windowsAppMutex.getHandleSoftwareRequestAction().receiveFile(filePath.trim());
            } else {
                log.warn("No action defined to handle received file path.");
            }
        } else if (message.startsWith("{getSoftwareVisibleDirective} ")) {
            String softwareVisibleDirective = message.trim();
            softwareVisibleDirective = softwareVisibleDirective.substring(softwareVisibleDirective.indexOf(" "));
            if (windowsAppMutex.getHandleSoftwareRequestAction() != null) {
                windowsAppMutex.getHandleSoftwareRequestAction().setVisible(Boolean.parseBoolean(softwareVisibleDirective.trim()));
            } else {
                log.warn("No action defined to handle software visible directive.");
            }
        } else {
            log.warn("Unknown message received: {}", (Object)message);
        }
    }

    @Generated
    public static void setWindowsAppMutex(WindowsAppMutex windowsAppMutex) {
        TCP_Handle.windowsAppMutex = windowsAppMutex;
    }

    @Generated
    public static WindowsAppMutex getWindowsAppMutex() {
        return windowsAppMutex;
    }
}

