/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.SoftwareChannel;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.SoftwareChannel.HandleSoftwareRequestAction;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.SoftwareChannel.TCP_Handle;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Client.TCP_Client;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Server.TCP_ServerSocket;
import top.nserly.SoftwareCollections_API.Thread.ThreadControl;

public class WindowsAppMutex {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsAppMutex.class);
    private final int port;
    private final Thread Init_Thread;
    private TCP_ServerSocket tcpServerSocket;
    private TCP_Client tcpClient;
    private boolean isFirstInstance;
    private HandleSoftwareRequestAction handleSoftwareRequestAction;
    private boolean isSupportedSoftwareName = true;
    private ScheduledExecutorService executor;

    public WindowsAppMutex(int port) {
        this.port = port;
        this.isFirstInstance = TCP_ServerSocket.isPortAvailable(port);
        this.Init_Thread = new Thread(() -> {
            if (!this.isFirstInstance) {
                log.info("Port {} is already in use.", (Object)port);
                this.tcpClient = new TCP_Client("127.0.0.1", port, TCP_Handle.class);
                try {
                    this.tcpClient.connect();
                    if (!this.tcpClient.isServerSupportedSoftwareName()) {
                        this.isSupportedSoftwareName = false;
                        log.error("The server does not support the required software name protocol.");
                        throw new RuntimeException("The server does not support the required software name protocol.");
                    }
                }
                catch (Exception e) {
                    log.warn(ExceptionHandler.getExceptionMessage(e));
                }
            } else {
                TCP_Handle.setWindowsAppMutex(this);
                this.tcpServerSocket = new TCP_ServerSocket(port, -1, TCP_Handle.class);
                this.tcpServerSocket.setCheckForClient(event -> {
                    String hostAddress = event.getInetAddress().getHostAddress();
                    log.info("New client connected: (IP: {},Port: {})", (Object)hostAddress, (Object)event.getPort());
                    return "127.0.0.1".equals(hostAddress) || "::1".equals(hostAddress);
                });
                this.executor = Executors.newSingleThreadScheduledExecutor();
                this.executor.scheduleAtFixedRate(() -> this.tcpServerSocket.checkConnectState(), 0L, 30L, TimeUnit.SECONDS);
                try {
                    this.tcpServerSocket.start();
                }
                catch (IOException e) {
                    log.warn("Server start failed: {}", (Object)e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        });
        this.Init_Thread.start();
    }

    public void sendFilePathToExistingInstance(String filePath) {
        if (this.isFirstInstance()) {
            throw new RuntimeException("This is the first instance, cannot send file path.");
        }
        ThreadControl.waitThreadsComplete(this.Init_Thread);
        if (!this.isSupportedSoftwareName) {
            throw new RuntimeException("The server does not support the required software name protocol.");
        }
        try {
            this.tcpClient.send("{newPicturePath} " + filePath);
        }
        catch (IOException e) {
            log.warn("Send file path failed: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void sendSoftwareVisibleDirectiveToExistingInstance(boolean visible) {
        if (this.isFirstInstance()) {
            throw new RuntimeException("This is the first instance, cannot send software visible directive.");
        }
        ThreadControl.waitThreadsComplete(this.Init_Thread);
        if (!this.isSupportedSoftwareName) {
            throw new RuntimeException("The server does not support the required software name protocol.");
        }
        try {
            this.tcpClient.send("{getSoftwareVisibleDirective} " + visible);
        }
        catch (IOException e) {
            log.warn("Send visible directive failed: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void addHandleSoftwareRequestAction(HandleSoftwareRequestAction handleSoftwareRequestAction) {
        if (handleSoftwareRequestAction == null) {
            throw new IllegalArgumentException("ReceiveSoftwareVisibleDirectiveAction cannot be null");
        }
        this.handleSoftwareRequestAction = handleSoftwareRequestAction;
    }

    public void close() {
        ThreadControl.waitThreadsComplete(this.Init_Thread);
        try {
            if (this.tcpClient != null) {
                this.tcpClient.close();
            }
        }
        catch (IOException e) {
            log.warn("Error closing TCP client: {}", (Object)e.getMessage());
        }
        try {
            if (this.tcpServerSocket != null) {
                this.tcpServerSocket.close();
            }
        }
        catch (IOException e) {
            log.warn("Error closing TCP server: {}", (Object)e.getMessage());
        }
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public boolean isFirstInstance() {
        return this.isFirstInstance;
    }

    @Generated
    public HandleSoftwareRequestAction getHandleSoftwareRequestAction() {
        return this.handleSoftwareRequestAction;
    }

    @Generated
    public boolean isSupportedSoftwareName() {
        return this.isSupportedSoftwareName;
    }
}

