/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Interactions;

public class TCP_Client {
    private static final String IPv4_REGEX = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private static final String IPv6_REGEX = "^(([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)|::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)$";
    private static final String DomainName_REGEX = "^([a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?\\.)+[a-z]{2,6}$";
    static Socket socket;
    private final Class<? extends Interactions> interactions;
    Interactions interaction = null;
    private String ServerIP;
    private int ServerPort;
    private Thread t;

    public TCP_Client(String ServerIP, int ServerPort, Class<? extends Interactions> interactions) {
        this.interactions = interactions;
        this.ServerIP = ServerIP;
        this.ServerPort = ServerPort;
    }

    public static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket serverSocket = new ServerSocket(port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        serverSocket.close();
        return bl;
    }

    public static boolean matchIP(String IP) {
        Matcher matcherIPv4 = Pattern.compile(IPv4_REGEX).matcher(IP);
        Matcher matcherIPv6 = Pattern.compile(IPv6_REGEX).matcher(IP);
        return matcherIPv4.matches() ^ matcherIPv6.matches();
    }

    public static boolean matchDomainName(String DomainName) {
        Matcher matcherDomainName = Pattern.compile(DomainName_REGEX).matcher(DomainName);
        return matcherDomainName.matches() ^ matcherDomainName.matches();
    }

    public static boolean matchPort(int port) {
        return port > 0 && port <= 65535;
    }

    public static boolean match(String IPOrDomainName, int port) {
        return TCP_Client.matchIP(IPOrDomainName) ^ TCP_Client.matchDomainName(IPOrDomainName) && TCP_Client.matchPort(port);
    }

    public void connect() throws IOException {
        String IP = this.ServerIP;
        int Port = this.ServerPort;
        socket = new Socket(IP, Port);
        try {
            Constructor<? extends Interactions> constructor = this.interactions.getConstructor(Socket.class);
            this.interaction = constructor.newInstance(socket);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        FutureTask<Integer> futureTask = new FutureTask<Integer>(this.interaction);
        this.t = new Thread(futureTask);
        this.t.start();
    }

    public void send(String message) throws IOException {
        socket.getOutputStream().write(message.getBytes());
        socket.getOutputStream().flush();
    }

    public void close() throws IOException {
        this.t.interrupt();
        this.t = null;
        socket.close();
    }

    public String getServerSupportedSoftwareName() throws IOException, ExecutionException, InterruptedException, TimeoutException {
        if (socket.isClosed()) {
            throw new RuntimeException("TCP_Client is not connected.");
        }
        CompletableFuture future = new CompletableFuture();
        this.interaction.setReceviceSoftwareNameInformationAction(future::complete);
        this.send("{getSoftwareName}");
        return (String)future.get(5L, TimeUnit.SECONDS);
    }

    public boolean isServerSupportedSoftwareName() throws IOException, ExecutionException, InterruptedException, TimeoutException {
        return this.getServerSupportedSoftwareName().equals(System.getProperty("SoftwareName"));
    }

    @Generated
    public static Socket getSocket() {
        return socket;
    }

    @Generated
    public String getServerIP() {
        return this.ServerIP;
    }

    @Generated
    public int getServerPort() {
        return this.ServerPort;
    }
}

