/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.ReceviceSoftwareNameInformationAction;
import top.nserly.SoftwareCollections_API.String.GetString;

public abstract class Interactions
implements Callable<Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Interactions.class);
    public final Socket socket;
    public String sendMessage;
    public ReceviceSoftwareNameInformationAction receviceSoftwareNameInformationAction;
    private long ms;
    private int tryCount = 0;
    public ArrayList<Socket> ClientSockets = null;

    public Interactions(Socket socket, ArrayList<Socket> ClientSockets) {
        this.socket = socket;
        this.ClientSockets = ClientSockets;
    }

    public static Interactions getInstance(Class<? extends Interactions> interactions, Socket socket, ArrayList<Socket> ClientSockets) {
        try {
            Constructor<? extends Interactions> constructor = interactions.getDeclaredConstructor(Socket.class, ArrayList.class);
            constructor.setAccessible(true);
            return constructor.newInstance(socket, ClientSockets);
        }
        catch (Exception e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
            return null;
        }
    }

    @Override
    public final Integer call() throws Exception {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> scheduledFuture = null;
        try {
            while (true) {
                if (this.socket.isClosed() || this.tryCount >= 3) {
                    log.info("Socket is closed, interaction thread is terminating. (IP: {}, Port: {})", (Object)this.socket.getInetAddress().getHostAddress(), (Object)this.socket.getPort());
                    this.ClientSockets.remove(this.socket);
                    throw new IOException("Socket is closed, interaction thread is terminating.");
                }
                this.sendMessage = GetString.getString(this.socket.getInputStream());
                if (this.sendMessage == null || this.sendMessage.isBlank()) {
                    ++this.tryCount;
                    if (this.ms == 0L) {
                        this.ms = System.currentTimeMillis();
                        continue;
                    }
                    long currentTime = System.currentTimeMillis();
                    long elapsedTime = currentTime - this.ms;
                    if (elapsedTime <= 10L) {
                        long sleepTime = 500L * (12L - elapsedTime) * (long)(this.tryCount + 1);
                        if (scheduledFuture != null && !scheduledFuture.isDone()) {
                            scheduledFuture.cancel(false);
                        }
                        scheduledFuture = scheduler.schedule(() -> {}, sleepTime, TimeUnit.MILLISECONDS);
                        this.ms = System.currentTimeMillis();
                        continue;
                    }
                    this.ms = System.currentTimeMillis();
                    continue;
                }
                this.tryCount = 0;
                int internalResult = this.internalInformationProcessing();
                if (internalResult != -1) continue;
                this.messageCall();
            }
        }
        catch (Throwable throwable) {
            if (scheduledFuture != null && !scheduledFuture.isDone()) {
                scheduledFuture.cancel(false);
            }
            scheduler.shutdown();
            throw throwable;
        }
    }

    private int internalInformationProcessing() throws Exception {
        if (this.sendMessage.equals("{getSoftwareName}")) {
            this.socket.getOutputStream().write(("{SoftwareName} " + System.getProperty("SoftwareName")).getBytes());
            this.socket.getOutputStream().flush();
            return 0;
        }
        if (this.sendMessage.startsWith("{SoftwareName} ")) {
            if (this.receviceSoftwareNameInformationAction != null) {
                String softwareName = this.sendMessage.substring("{SoftwareName} ".length());
                this.receviceSoftwareNameInformationAction.receiveSoftwareName(softwareName.trim());
            }
            return 0;
        }
        return -1;
    }

    public abstract int messageCall() throws Exception;

    @Generated
    public void setReceviceSoftwareNameInformationAction(ReceviceSoftwareNameInformationAction receviceSoftwareNameInformationAction) {
        this.receviceSoftwareNameInformationAction = receviceSoftwareNameInformationAction;
    }

    @Generated
    public ReceviceSoftwareNameInformationAction getReceviceSoftwareNameInformationAction() {
        return this.receviceSoftwareNameInformationAction;
    }
}

