/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Server;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Interactions;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Server.CheckClient;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Server.WaitForConnectClient;

public class TCP_ServerSocket {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TCP_ServerSocket.class);
    protected Set<String> BlackList = new HashSet<String>();
    protected CheckClient CheckForClient;
    protected int MaxConnect;
    protected ExecutorService ThreadPool;
    protected Class<? extends Interactions> interactions;
    private WaitForConnectClient waitForConnectClient;
    ArrayList<Socket> ClientSockets = new ArrayList();
    private ServerSocket serverSocket;
    private String IPv4;
    private String IPv6;
    private int port;

    public TCP_ServerSocket(int port, int MaxConnect, Class<? extends Interactions> interactions) {
        InetAddress localhost;
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet6Address) || inetAddress.isLinkLocalAddress()) continue;
                this.IPv6 = inetAddress.getHostAddress();
            }
        }
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.IPv4 = localhost.getHostAddress();
        this.port = port;
        this.MaxConnect = MaxConnect;
        this.interactions = interactions;
    }

    public static boolean isPortAvailable(int port) {
        boolean bl;
        block8: {
            ServerSocketChannel channel = ServerSocketChannel.open();
            try {
                channel.socket().setReuseAddress(true);
                channel.socket().bind(new InetSocketAddress(port));
                bl = true;
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            channel.close();
        }
        return bl;
    }

    public static void send(Socket socket, String message) throws IOException {
        if (socket == null || !socket.isConnected()) {
            throw new IllegalArgumentException("Socket is null or not connected");
        }
        if (message == null || message.isEmpty()) {
            throw new IllegalArgumentException("Message cannot be null or empty");
        }
        socket.getOutputStream().write(message.getBytes());
        socket.getOutputStream().flush();
    }

    public void changeBlackList(Set<String> BlackIP) {
        this.BlackList = BlackIP;
    }

    public void changeBlackList(List<String> BlackIP) {
        this.BlackList = new HashSet<String>();
        this.BlackList.addAll(BlackIP);
    }

    public void changeBlackList(String ... BlackIP) {
        this.BlackList = new HashSet<String>();
        this.BlackList.addAll(Arrays.asList(BlackIP));
    }

    public ArrayList<Socket> checkAndGetClientSockets() {
        this.checkConnectState();
        return this.ClientSockets;
    }

    public Set<String> getClientIP() {
        if (this.ClientSockets.isEmpty()) {
            return null;
        }
        HashSet<String> cache = new HashSet<String>();
        this.ClientSockets.forEach(e -> cache.add(e.getInetAddress().getHostAddress()));
        return cache;
    }

    public void disconnect(String IP) {
        ArrayList<Socket> arrayList = this.ClientSockets;
        for (Socket i : arrayList) {
            if (!i.getInetAddress().getHostAddress().equals(IP)) continue;
            try {
                i.close();
                arrayList.remove(i);
            }
            catch (IOException iOException) {}
        }
    }

    public void addBlackListByCurrentSocket(Socket client) {
        String IP = client.getInetAddress().getHostAddress();
        this.disconnect(IP);
        this.addBlackList(IP);
    }

    public void cleanBlacklist() {
        this.BlackList.clear();
    }

    public synchronized void checkConnectState() {
        if (this.ClientSockets == null) {
            return;
        }
        HashSet<Socket> cache = new HashSet<Socket>(this.ClientSockets);
        for (Socket i : cache) {
            if (i.isClosed()) {
                try {
                    i.close();
                }
                catch (IOException ignored) {
                    this.ClientSockets.remove(i);
                }
            }
            try {
                i.sendUrgentData(1);
            }
            catch (IOException e) {
                try {
                    i.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.ClientSockets.remove(i);
            }
        }
    }

    public void close() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        Thread closeConnectClient = null;
        if (this.waitForConnectClient != null) {
            closeConnectClient = new Thread(this.waitForConnectClient::stop);
            closeConnectClient.start();
        }
        if (this.ThreadPool != null) {
            this.ThreadPool.close();
        }
        if (closeConnectClient != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void removeBlackIP(String BlackIP) {
        this.BlackList.remove(BlackIP);
    }

    public boolean containsBlack(String BlackIP) {
        return this.BlackList.contains(BlackIP);
    }

    public void addBlackList(String BlackIP) {
        this.BlackList.add(BlackIP);
    }

    public void addBlackList(List<String> BlackIP) {
        this.BlackList.addAll(BlackIP);
    }

    public void addBlackList(String ... BlackIP) {
        this.BlackList.addAll(Arrays.asList(BlackIP));
    }

    public void addBlackList(Set<String> BlackIP) {
        this.BlackList.addAll(BlackIP);
    }

    public void start() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.waitForConnectClient = new WaitForConnectClient(this.serverSocket, this);
        new Thread(this.waitForConnectClient).start();
    }

    @Generated
    public Set<String> getBlackList() {
        return this.BlackList;
    }

    @Generated
    public void setCheckForClient(CheckClient CheckForClient) {
        this.CheckForClient = CheckForClient;
    }

    @Generated
    public int getMaxConnect() {
        return this.MaxConnect;
    }

    @Generated
    public void setMaxConnect(int MaxConnect) {
        this.MaxConnect = MaxConnect;
    }

    @Generated
    public ExecutorService getThreadPool() {
        return this.ThreadPool;
    }

    @Generated
    public ArrayList<Socket> getClientSockets() {
        return this.ClientSockets;
    }

    @Generated
    public String getIPv4() {
        return this.IPv4;
    }

    @Generated
    public String getIPv6() {
        return this.IPv6;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

