/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Interactions;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.TCP.Server.TCP_ServerSocket;

class WaitForConnectClient
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WaitForConnectClient.class);
    private final ServerSocket ServerSocket;
    private final TCP_ServerSocket tcpServerSocket;
    private boolean end;

    public WaitForConnectClient(ServerSocket serverSocket, TCP_ServerSocket tcpServerSocket) {
        this.ServerSocket = serverSocket;
        this.tcpServerSocket = tcpServerSocket;
    }

    public void stop() {
        this.end = true;
    }

    @Override
    public void run() {
        block2: while (!this.end) {
            try {
                Socket socket = this.ServerSocket.accept();
                log.info("new connection request from {}", (Object)socket.getInetAddress().getHostAddress());
                if (this.tcpServerSocket.MaxConnect != -1 && this.tcpServerSocket.ClientSockets.size() > this.tcpServerSocket.MaxConnect) {
                    socket.close();
                    log.info("connection refused ({}),Caused by:Current Connection counts has been over MaxConnect({})", (Object)socket.getInetAddress().getHostAddress(), (Object)this.tcpServerSocket.MaxConnect);
                    continue;
                }
                if (this.tcpServerSocket.BlackList != null && !this.tcpServerSocket.BlackList.isEmpty()) {
                    for (String s : this.tcpServerSocket.BlackList) {
                        if (!s.equals(socket.getInetAddress().getHostAddress())) continue;
                        socket.close();
                        log.info("connection refused ({}),Caused by:Address is in BlackList", (Object)socket.getInetAddress().getHostAddress());
                        continue block2;
                    }
                }
                if (this.tcpServerSocket.CheckForClient != null && !this.tcpServerSocket.CheckForClient.Check(socket)) {
                    socket.close();
                    log.info("connection refused ({}),Caused by:Developer's definition", (Object)socket.getInetAddress().getHostAddress());
                    continue;
                }
                ArrayList<Socket> set = this.tcpServerSocket.ClientSockets;
                if (set == null) {
                    set = new ArrayList();
                }
                set.add(socket);
                this.tcpServerSocket.ClientSockets = set;
                if (this.tcpServerSocket.ThreadPool == null) {
                    this.tcpServerSocket.ThreadPool = Executors.newFixedThreadPool(this.tcpServerSocket.MaxConnect == -1 ? 999 : this.tcpServerSocket.MaxConnect);
                }
                this.tcpServerSocket.ThreadPool.execute(new FutureTask(Objects.requireNonNull(Interactions.getInstance(this.tcpServerSocket.interactions, socket, this.tcpServerSocket.ClientSockets))));
            }
            catch (IOException e) {
                if (this.end) break;
                for (Socket socket : this.tcpServerSocket.ClientSockets) {
                    if (!socket.isClosed()) continue;
                    this.tcpServerSocket.ClientSockets.remove(socket);
                    log.info("Closed socket: {}", (Object)socket.getInetAddress().getHostAddress());
                }
            }
        }
    }
}

