/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Notifications;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.GUIStarter;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.Interaction.SoftwareInteraction.SoftwareChannel.SystemTrayEvent;

public class SystemNotifications {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemNotifications.class);
    public static final boolean isSupportedSystemNotifications = SystemTray.isSupported();
    public static TrayIcon DefaultIcon;
    public static int createdSystemTrayCount;

    public static void sendMessage(TrayIcon trayIcon, String caption, String text, TrayIcon.MessageType messageType) {
        if (!isSupportedSystemNotifications) {
            throw new RuntimeException("System Notifications is not supported!");
        }
        trayIcon.displayMessage(caption, text, messageType);
    }

    public static SystemTray getSystemTray(TrayIcon trayIcon, MenuItem[] menuItems, final SystemTrayEvent systemTrayEvent) {
        if (!isSupportedSystemNotifications) {
            throw new RuntimeException("System Notifications is not supported!");
        }
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            log.warn("System tray is not supported!Because your system is Linux or Unix-like system.Because they don't offer this type of support by default!");
            return null;
        }
        SystemTray tray = SystemTray.getSystemTray();
        trayIcon.setImageAutoSize(true);
        PopupMenu popup = new PopupMenu();
        for (int i = 0; i < menuItems.length; ++i) {
            if (menuItems[i] == null) {
                throw new RuntimeException("MenuItem cannot be null");
            }
            popup.add(menuItems[i]);
            if (i + 1 == menuItems.length) continue;
            popup.addSeparator();
        }
        trayIcon.setPopupMenu(popup);
        if (systemTrayEvent != null) {
            trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    systemTrayEvent.mouseClicked(e);
                }
            });
        }
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e) {
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
        ++createdSystemTrayCount;
        return tray;
    }

    static {
        try {
            BufferedImage bufferedImage = ImageIO.read(Objects.requireNonNull(GUIStarter.class.getResource("tray.png")));
            DefaultIcon = new TrayIcon(bufferedImage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

