/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.Linux;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.Linux.X11;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.ScreenInfo;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.ScreenProvider;

public class LinuxScreenProvider
implements ScreenProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LinuxScreenProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScreenInfo> reloadScreens() {
        Pointer display = X11.INSTANCE.XOpenDisplay(null);
        if (display == null) {
            throw new RuntimeException("\u65e0\u6cd5\u6253\u5f00 X11 \u663e\u793a");
        }
        try {
            int screenCount = X11.INSTANCE.XScreenCount(display);
            ArrayList<ScreenInfo> screens = new ArrayList<ScreenInfo>(screenCount);
            for (int i = 0; i < screenCount; ++i) {
                IntByReference depthRef;
                IntByReference borderWidthRef;
                IntByReference heightRef;
                IntByReference widthRef;
                IntByReference yRef;
                IntByReference xRef;
                PointerByReference rootRef;
                Pointer rootWindow = X11.INSTANCE.XRootWindow(display, i);
                int result = X11.INSTANCE.XGetGeometry(display, rootWindow, rootRef = new PointerByReference(), xRef = new IntByReference(), yRef = new IntByReference(), widthRef = new IntByReference(), heightRef = new IntByReference(), borderWidthRef = new IntByReference(), depthRef = new IntByReference());
                if (result == 0) {
                    log.error("\u65e0\u6cd5\u83b7\u53d6\u5c4f\u5e55 {} \u7684\u51e0\u4f55\u4fe1\u606f", (Object)i);
                    continue;
                }
                int width = Math.abs(widthRef.getValue());
                int height = Math.abs(heightRef.getValue());
                Dimension screenSize = new Dimension(width, height);
                Dimension usableScreenSize = new Dimension(width, height);
                ScreenInfo screenInfo = new ScreenInfo(i, screenSize, usableScreenSize, xRef.getValue(), yRef.getValue(), i == 0);
                screens.add(screenInfo);
            }
            ArrayList<ScreenInfo> arrayList = screens;
            return arrayList;
        }
        finally {
            X11.INSTANCE.XCloseDisplay(display);
        }
    }

    @Override
    public ScreenInfo getScreenForWindow(long windowHandle) {
        Pointer display = X11.INSTANCE.XOpenDisplay(null);
        if (display == null) {
            throw new RuntimeException("\u65e0\u6cd5\u6253\u5f00 X11 \u663e\u793a");
        }
        try {
            int screenCount = X11.INSTANCE.XScreenCount(display);
            for (int i = 0; i < screenCount; ++i) {
                Pointer rootWindow = X11.INSTANCE.XRootWindow(display, i);
                if (windowHandle != Pointer.nativeValue((Pointer)rootWindow)) continue;
                PointerByReference rootRef = new PointerByReference();
                IntByReference xRef = new IntByReference();
                IntByReference yRef = new IntByReference();
                IntByReference widthRef = new IntByReference();
                IntByReference heightRef = new IntByReference();
                IntByReference borderWidthRef = new IntByReference();
                IntByReference depthRef = new IntByReference();
                int result = X11.INSTANCE.XGetGeometry(display, rootWindow, rootRef, xRef, yRef, widthRef, heightRef, borderWidthRef, depthRef);
                if (result == 0) {
                    throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5c4f\u5e55\u51e0\u4f55\u4fe1\u606f");
                }
                int width = Math.abs(widthRef.getValue());
                int height = Math.abs(heightRef.getValue());
                Dimension screenSize = new Dimension(width, height);
                Dimension usableScreenSize = new Dimension(width, height);
                ScreenInfo screenInfo = new ScreenInfo(i, screenSize, usableScreenSize, xRef.getValue(), yRef.getValue(), i == 0);
                return screenInfo;
            }
            throw new RuntimeException("\u672a\u627e\u5230\u7a97\u53e3\u6240\u5728\u7684\u5c4f\u5e55");
        }
        finally {
            X11.INSTANCE.XCloseDisplay(display);
        }
    }
}

