/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen;

import java.awt.Dimension;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.Linux.LinuxScreenProvider;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.ScreenInfo;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.ScreenProvider;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.Windows.WindowsScreenProvider;

public class ScreenManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScreenManager.class);
    private static final ScreenProvider screenProvider;
    private static final List<ScreenInfo> allScreens;
    private static ScreenInfo primaryScreen;

    public static synchronized void reload() {
        allScreens.clear();
        allScreens.addAll(screenProvider.reloadScreens());
        primaryScreen = allScreens.stream().filter(ScreenInfo::isPrimary).findFirst().orElse(allScreens.isEmpty() ? null : allScreens.getFirst());
    }

    public static List<ScreenInfo> getAllScreens() {
        return List.copyOf(allScreens);
    }

    public static int getScreenCount() {
        return allScreens.size();
    }

    public static ScreenInfo getScreen(int index) {
        if (index >= 0 && index < allScreens.size()) {
            return allScreens.get(index);
        }
        return null;
    }

    public static ScreenInfo getScreenForWindow(Window window) {
        if (window == null) {
            return ScreenManager.getPrimaryScreen();
        }
        long windowHandle = ScreenManager.getWindowHandle(window);
        return screenProvider.getScreenForWindow(windowHandle);
    }

    public static ScreenInfo getScreenAt(int x, int y) {
        for (ScreenInfo screen : allScreens) {
            if (x < screen.x() || x >= screen.x() + screen.screenSize().width || y < screen.y() || y >= screen.y() + screen.screenSize().height) continue;
            return screen;
        }
        return ScreenManager.getPrimaryScreen();
    }

    public static Dimension getTotalScreenSize() {
        if (allScreens.isEmpty()) {
            return new Dimension(0, 0);
        }
        int minX = allScreens.stream().mapToInt(ScreenInfo::x).min().orElse(0);
        int minY = allScreens.stream().mapToInt(ScreenInfo::y).min().orElse(0);
        int maxX = allScreens.stream().mapToInt(s -> s.x() + s.screenSize().width).max().orElse(0);
        int maxY = allScreens.stream().mapToInt(s -> s.y() + s.screenSize().height).max().orElse(0);
        return new Dimension(maxX - minX, maxY - minY);
    }

    private static long getWindowHandle(Window window) {
        try {
            Method getPeerMethod = window.getClass().getMethod("getPeer", new Class[0]);
            Object peer = getPeerMethod.invoke((Object)window, new Object[0]);
            if (peer.getClass().getName().contains("WWindowPeer")) {
                Field hwndField = peer.getClass().getDeclaredField("hwnd");
                hwndField.setAccessible(true);
                return hwndField.getLong(peer);
            }
            if (peer.getClass().getName().contains("XWindowPeer")) {
                Field windowField = peer.getClass().getDeclaredField("window");
                windowField.setAccessible(true);
                return windowField.getLong(peer);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to get window handle: " + e.getMessage());
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
        return 0L;
    }

    @Generated
    public static ScreenInfo getPrimaryScreen() {
        return primaryScreen;
    }

    static {
        allScreens = new CopyOnWriteArrayList<ScreenInfo>();
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            screenProvider = new WindowsScreenProvider();
        } else if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            screenProvider = new LinuxScreenProvider();
        } else {
            throw new UnsupportedOperationException("Unsupported operating system: " + osName);
        }
        ScreenManager.reload();
    }
}

