/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.Windows;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.nserly.SoftwareCollections_API.Handler.Exception.ExceptionHandler;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.ScreenInfo;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.ScreenManager;
import top.nserly.SoftwareCollections_API.Interaction.SystemInteraction.Screen.ScreenProvider;

public class WindowsScreenProvider
implements ScreenProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsScreenProvider.class);
    private static final User32 user32 = User32.INSTANCE;

    @Override
    public List<ScreenInfo> reloadScreens() {
        ArrayList<ScreenInfo> screens = new ArrayList<ScreenInfo>();
        AtomicInteger index = new AtomicInteger();
        user32.EnumDisplayMonitors(null, null, (hMonitor, hdcMonitor, rect, lParam) -> {
            WinUser.MONITORINFOEX monitorInfo = new WinUser.MONITORINFOEX();
            monitorInfo.cbSize = monitorInfo.size();
            if (user32.GetMonitorInfo(hMonitor, monitorInfo).booleanValue()) {
                int width = monitorInfo.rcMonitor.right - monitorInfo.rcMonitor.left;
                int height = monitorInfo.rcMonitor.bottom - monitorInfo.rcMonitor.top;
                int usableWidth = monitorInfo.rcWork.right - monitorInfo.rcWork.left;
                int usableHeight = monitorInfo.rcWork.bottom - monitorInfo.rcWork.top;
                boolean isPrimary = (monitorInfo.dwFlags & 1) != 0;
                screens.add(new ScreenInfo(index.getAndIncrement(), new Dimension(width, height), new Dimension(usableWidth, usableHeight), monitorInfo.rcMonitor.left, monitorInfo.rcMonitor.top, isPrimary));
            }
            return 1;
        }, null);
        return screens;
    }

    @Override
    public ScreenInfo getScreenForWindow(long windowHandle) {
        if (windowHandle == 0L) {
            return ScreenManager.getPrimaryScreen();
        }
        try {
            WinDef.HWND hwnd = new WinDef.HWND();
            hwnd.setPointer(Pointer.createConstant((long)windowHandle));
            WinUser.HMONITOR hMonitor = user32.MonitorFromWindow(hwnd, 2);
            WinDef.RECT rect = new WinDef.RECT();
            user32.GetWindowRect(hwnd, rect);
            List<ScreenInfo> screens = ScreenManager.getAllScreens();
            for (ScreenInfo screen : screens) {
                if (rect.left < screen.x() || rect.left >= screen.x() + screen.screenSize().width || rect.top < screen.y() || rect.top >= screen.y() + screen.screenSize().height) continue;
                return screen;
            }
        }
        catch (Exception e) {
            log.error("Error getting screen for window: {}", (Object)e.getMessage());
            log.error(ExceptionHandler.getExceptionMessage(e));
        }
        return ScreenManager.getPrimaryScreen();
    }
}

