/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.OSInformation;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class SystemMonitor {
    public static final String PROGRAM_START_TIME;
    public static final int CPU_CORE_COUNT;
    public static final int CPU_Physical_Core_Count;
    public static final int CPU_Logical_Thread_Count;
    public static final String OS_NAME;
    public static final String JAVA_HOME;
    public static final String JAVA_VERSION;
    public static final String USER_HOME;
    public static final String USER_NAME;
    public static final String CPU_NAME;
    public static long JVM_Initialize_Memory;
    public static long JVM_Maximum_Free_Memory;
    public static long JVM_Used_Memory;
    public static long Physical_Memory;
    public static long Physical_Free_Memory;
    public static int Program_Thread_Count;
    public static long Physical_Used_Memory;
    public static double JVM_Memory_Usage;
    public static double Physical_Memory_Usage;

    public static void getInformation() {
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        JVM_Initialize_Memory = memoryUsage.getInit();
        JVM_Maximum_Free_Memory = memoryUsage.getMax();
        JVM_Used_Memory = memoryUsage.getUsed();
        Physical_Memory = osBean.getTotalMemorySize();
        Physical_Free_Memory = osBean.getFreeMemorySize();
        Physical_Used_Memory = Physical_Memory - Physical_Free_Memory;
        ThreadGroup rootThreadGroup = SystemMonitor.getRootThreadGroup(Thread.currentThread().getThreadGroup());
        Program_Thread_Count = rootThreadGroup.activeCount();
        DecimalFormat df = new DecimalFormat("#.##");
        JVM_Memory_Usage = JVM_Maximum_Free_Memory > 0L ? Double.parseDouble(df.format(100.0 * (double)JVM_Used_Memory / (double)JVM_Maximum_Free_Memory)) : 0.0;
        Physical_Memory_Usage = Physical_Used_Memory > 0L ? Double.parseDouble(df.format(100.0 * (double)Physical_Free_Memory / (double)Physical_Used_Memory)) : 0.0;
    }

    private static ThreadGroup getRootThreadGroup(ThreadGroup group) {
        if (group.getParent() != null) {
            return SystemMonitor.getRootThreadGroup(group.getParent());
        }
        return group;
    }

    public static String convertSize(long sizeInBytes) {
        int unitIndex;
        double size = sizeInBytes;
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        for (unitIndex = 0; size >= 1024.0 && unitIndex < units.length - 1; size /= 1024.0, ++unitIndex) {
        }
        return String.format("%.2f %s", size, units[unitIndex]);
    }

    static {
        OS_NAME = System.getProperty("os.name");
        PROGRAM_START_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(ManagementFactory.getRuntimeMXBean().getStartTime()));
        CPU_CORE_COUNT = Runtime.getRuntime().availableProcessors();
        JAVA_HOME = System.getProperty("java.home");
        JAVA_VERSION = System.getProperty("java.version");
        USER_HOME = System.getProperty("user.home");
        USER_NAME = System.getProperty("user.name");
        SystemInfo systemInfo = new SystemInfo();
        CentralProcessor processor = systemInfo.getHardware().getProcessor();
        CPU_Physical_Core_Count = processor.getPhysicalProcessorCount();
        CPU_Logical_Thread_Count = processor.getLogicalProcessorCount();
        CPU_NAME = processor.getProcessorIdentifier().getName();
    }
}

