/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Queue;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolTaskQueue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolTaskQueue.class);
    private final ThreadPoolExecutor threadPool;
    private final int maxThreadCount;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);

    public ThreadPoolTaskQueue(int corePoolSize, int maxThreadCount) {
        if (corePoolSize <= 0 || maxThreadCount <= 0 || corePoolSize > maxThreadCount) {
            throw new IllegalArgumentException("The thread number parameter is not legitimate");
        }
        this.maxThreadCount = maxThreadCount;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(1024);
        RejectedExecutionHandler handler = (r, executor) -> {
            try {
                if (!executor.getQueue().offer(r, 1L, TimeUnit.SECONDS)) {
                    throw new RejectedExecutionException("The task queue is full, and adding tasks fails");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Task addition is interrupted", e);
            }
        };
        this.threadPool = new ThreadPoolExecutor(corePoolSize, maxThreadCount, 60L, TimeUnit.SECONDS, workQueue, Executors.defaultThreadFactory(), handler);
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    public Future<?> addTask(Runnable task) {
        if (!this.isRunning.get() || task == null) {
            return null;
        }
        try {
            return this.threadPool.submit(task);
        }
        catch (RejectedExecutionException e) {
            log.error("Adding a task failed: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void stop(boolean waitForCompletion) {
        if (this.isRunning.compareAndSet(true, false)) {
            if (waitForCompletion) {
                this.threadPool.shutdown();
                try {
                    if (!this.threadPool.awaitTermination(1L, TimeUnit.MINUTES)) {
                        this.threadPool.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.threadPool.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            } else {
                this.threadPool.shutdownNow();
            }
        }
    }

    public int getActiveThreadCount() {
        return this.threadPool.getActiveCount();
    }

    public int getPendingTaskCount() {
        return this.threadPool.getQueue().size();
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    @Generated
    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }
}

