/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.SoftwareCollections_API.Thread;

public class ThreadControl {
    private ThreadControl() {
    }

    public static boolean waitThreadsComplete(Thread ... threads) {
        return ThreadControl.waitThreadsComplete(0L, threads);
    }

    public static boolean waitThreadsComplete(long waitingTime, Thread ... threads) {
        long startTime = System.currentTimeMillis();
        if (threads == null) {
            return true;
        }
        for (Thread thread : threads) {
            if (thread == null) continue;
            long elapsed = System.currentTimeMillis() - startTime;
            long remaining = waitingTime - elapsed;
            if (remaining <= 0L && waitingTime != 0L) {
                return !thread.isAlive();
            }
            try {
                thread.join(Math.max(0L, remaining));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            if (!thread.isAlive()) continue;
            return false;
        }
        return true;
    }
}

