/*
 * Decompiled with CFR 0.152.
 */
package top.nserly.Utils.Download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import top.nserly.Utils.Download.DownloadErrorHandler;

public class FileDownloader
implements Runnable {
    private int redirectCount = 0;
    private static final int MAX_REDIRECTS = 5;
    private static final int BUFFER_SIZE = 524288;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private static final String TEMP_SUFFIX = ".download";
    private static final int PROGRESS_UPDATE_INTERVAL = 100;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final AtomicBoolean isCompleted = new AtomicBoolean(false);
    private final AtomicLong bytesRead = new AtomicLong(0L);
    private volatile long fileSize = -1L;
    private volatile double downloadProgress = 0.0;
    private volatile double bytesPerSecond = 0.0;
    private volatile long remainingTime = -1L;
    private String sourceUrl;
    private final String saveDirectory;
    private String finalFileName;
    private String tempFilePath;
    private long lastUpdateTime;
    private long lastBytesRecord;
    private DownloadErrorHandler downloadErrorHandler;

    public FileDownloader(String sourceUrl, String saveDirectory) {
        this(sourceUrl, saveDirectory, null);
    }

    public FileDownloader(String sourceUrl, String saveDirectory, DownloadErrorHandler downloadErrorHandler) {
        this.sourceUrl = sourceUrl;
        this.saveDirectory = this.normalizeDirectoryPath(saveDirectory);
        this.createSaveDirectory();
        this.downloadErrorHandler = downloadErrorHandler;
    }

    public void startDownloadInNewThread() {
        new Thread(this).start();
    }

    public void startDownload() {
        this.run();
    }

    @Override
    public void run() {
        try {
            if (this.bytesRead.get() > 0L) {
                this.resumeDownload();
            } else {
                this.startNewDownload();
            }
            this.completeDownload();
        }
        catch (IOException e) {
            if (this.downloadErrorHandler != null) {
                this.downloadErrorHandler.handler(e, this);
            } else {
                this.handleDownloadError(e);
            }
        }
        finally {
            this.cleanResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewDownload() throws IOException {
        HttpURLConnection connection = this.createConnection(false);
        try {
            this.validateResponse(connection);
            if (connection.getResponseCode() == 301 || connection.getResponseCode() == 302) {
                return;
            }
            this.initializeFileInfo(connection);
            try (InputStream is = connection.getInputStream();
                 FileOutputStream os = new FileOutputStream(this.tempFilePath);){
                this.downloadStream(is, os);
            }
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeDownload() throws IOException {
        HttpURLConnection connection = this.createConnection(true);
        try {
            if (connection.getResponseCode() != 206) {
                System.err.println("Server doesn't support resume, restarting download");
                this.resetDownload();
                this.startNewDownload();
                return;
            }
            try (InputStream is = connection.getInputStream();
                 FileOutputStream os = new FileOutputStream(this.tempFilePath, true);){
                this.downloadStream(is, os);
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private void downloadStream(InputStream is, OutputStream os) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(is, 524288);){
            int readBytes;
            byte[] buffer = new byte[524288];
            while ((readBytes = bis.read(buffer)) != -1) {
                if (this.isStopped.get()) {
                    System.out.println("Download stopped by user");
                    return;
                }
                os.write(buffer, 0, readBytes);
                this.updateProgress(readBytes);
                this.calculateMetrics();
            }
        }
    }

    private HttpURLConnection createConnection(boolean isResume) throws IOException {
        int retry = 0;
        while (retry++ < 3) {
            try {
                URL url = URL.of(URI.create(this.sourceUrl), null);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (isResume) {
                    connection.setRequestProperty("Range", "bytes=" + this.bytesRead.get() + "-");
                }
                return connection;
            }
            catch (IOException e) {
                if (retry == 3) {
                    throw e;
                }
                System.err.println("Connection failed, retrying... (" + retry + "/3)");
            }
        }
        throw new IOException("Failed to establish connection after 3 attempts");
    }

    private void initializeFileInfo(HttpURLConnection connection) throws IOException {
        String fileName = this.getFileNameFromHeader(connection);
        if (fileName == null) {
            fileName = this.getFileNameFromUrl();
        }
        this.finalFileName = this.generateUniqueFileName(fileName);
        this.tempFilePath = this.saveDirectory + this.finalFileName + TEMP_SUFFIX;
        this.fileSize = connection.getContentLengthLong();
        if (this.fileSize == -1L) {
            System.err.println("File size unknown, progress tracking limited");
        }
    }

    private String generateUniqueFileName(String baseName) {
        Object name = baseName;
        int counter = 1;
        while (new File(this.saveDirectory + (String)name).exists()) {
            int dotIndex = baseName.lastIndexOf(46);
            name = dotIndex > 0 ? baseName.substring(0, dotIndex) + "(" + counter + ")" + baseName.substring(dotIndex) : baseName + "(" + counter + ")";
            ++counter;
        }
        return name;
    }

    private synchronized void updateProgress(int bytes) {
        this.bytesRead.addAndGet(bytes);
        if (this.fileSize > 0L) {
            this.downloadProgress = (double)this.bytesRead.get() * 100.0 / (double)this.fileSize;
            this.remainingTime = this.calculateRemainingTime();
        }
    }

    private synchronized void calculateMetrics() {
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - this.lastUpdateTime;
        if (elapsed >= 100L) {
            double bytesDiff = this.bytesRead.get() - this.lastBytesRecord;
            this.bytesPerSecond = bytesDiff * 1000.0 / (double)elapsed;
            this.lastUpdateTime = currentTime;
            this.lastBytesRecord = this.bytesRead.get();
        }
    }

    private long calculateRemainingTime() {
        if (this.fileSize <= 0L || this.bytesPerSecond <= 0.0) {
            return -1L;
        }
        long remainingBytes = this.fileSize - this.bytesRead.get();
        return (long)((double)remainingBytes / this.bytesPerSecond);
    }

    private void completeDownload() throws IOException {
        if (this.isStopped.get()) {
            return;
        }
        File tempFile = new File(this.tempFilePath);
        File finalFile = new File(this.saveDirectory + this.finalFileName);
        if (!tempFile.renameTo(finalFile)) {
            try (FileInputStream in = new FileInputStream(tempFile);
                 FileOutputStream out = new FileOutputStream(finalFile);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            tempFile.delete();
        }
        this.isCompleted.set(true);
        System.out.println("Download completed: " + finalFile.getAbsolutePath());
    }

    private void handleDownloadError(IOException e) {
        System.err.println("Download failed: " + e.getMessage());
        if (e instanceof FileNotFoundException) {
            System.err.println("File not found on server");
        }
    }

    private void cleanResources() {
        if (this.isStopped.get() && !this.isCompleted.get()) {
            new File(this.tempFilePath).delete();
            System.out.println("Cleaned temp file");
        }
    }

    private void validateResponse(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 301 || responseCode == 302) {
            this.handleRedirect(connection);
            return;
        }
        if (responseCode != 200 && responseCode != 206) {
            throw new IOException("Invalid HTTP response code: " + responseCode + " | Messages: " + connection.getResponseMessage());
        }
    }

    private void handleRedirect(HttpURLConnection connection) throws IOException {
        if (this.redirectCount++ >= 5) {
            throw new IOException("The maximum number of redirects is exceeded (5)");
        }
        String newUrl = connection.getHeaderField("Location");
        if (newUrl == null) {
            throw new IOException("A redirect response is received but there is no Location header");
        }
        this.sourceUrl = newUrl;
        System.out.println("A redirect to was detected: " + newUrl);
        this.startNewDownload();
    }

    private String normalizeDirectoryPath(String path) {
        return (path = path.replace("\\", "/")).endsWith("/") ? path : path + "/";
    }

    private void createSaveDirectory() {
        File dir = new File(this.saveDirectory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Failed to create save directory");
        }
    }

    private String getFileNameFromHeader(HttpURLConnection connection) {
        String[] tokens;
        String disposition = connection.getHeaderField("Content-Disposition");
        if (disposition == null) {
            return null;
        }
        for (String token : tokens = disposition.split(";")) {
            if (!(token = token.trim()).startsWith("filename=")) continue;
            String encodedName = token.substring(9).trim().replace("\"", "");
            return new String(encodedName.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        return null;
    }

    private String getFileNameFromUrl() {
        try {
            URL url = URL.of(URI.create(this.sourceUrl), null);
            String path = url.getPath();
            int slashIndex = path.lastIndexOf(47);
            return slashIndex == -1 ? path : path.substring(slashIndex + 1);
        }
        catch (MalformedURLException e) {
            System.err.println("Invalid URL format: " + this.sourceUrl);
            return "unknown_file";
        }
    }

    public void stopDownload() {
        this.isStopped.set(true);
    }

    public void resetDownload() {
        this.bytesRead.set(0L);
        this.downloadProgress = 0.0;
        this.bytesPerSecond = 0.0;
        this.remainingTime = -1L;
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }

    public double getSpeedBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public long getRemainingSeconds() {
        return this.remainingTime;
    }

    public boolean isCompleted() {
        return this.isCompleted.get();
    }

    public String getFinalPath() {
        return this.saveDirectory + this.finalFileName;
    }

    @Generated
    public long getFileSize() {
        return this.fileSize;
    }

    @Generated
    public double getDownloadProgress() {
        return this.downloadProgress;
    }

    @Generated
    public void setDownloadErrorHandler(DownloadErrorHandler downloadErrorHandler) {
        this.downloadErrorHandler = downloadErrorHandler;
    }
}

